package{
	import flash.display.Sprite;
	import flash.utils.Timer;
	import flash.events.TimerEvent;	
	import com.physicscodes.math.Graph;
	import com.physicscodes.objects.Ball;	
	
	public class ProjectileEnergy extends Sprite{		
		private var u:Number = 50; // prędkość początkowa
		private var g:Number = 10; // przyśpieszenie grawitacyjne
		private var groundLevel:Number=350;		
		private var n:int=0;						
		private	var tA:Array = new Array();
		private var hA:Array=new Array();			
		private	var peA:Array = new Array();
		private	var keA:Array = new Array();			
		private	var teA:Array = new Array();		
		private var ball:Ball;						
		private var timer:Timer;		
		private var graph:Graph;
	
		public function ProjectileEnergy(){
			init();			
		}		
		private function init():void{
			setupBall();			
			setupGraph();
			setupArrays();			
			setupTimer();
		}
		
		private function setupBall():void{
			ball = new Ball(10);
			ball.x = 550;
			ball.y = groundLevel;
			addChild(ball);			
		}
		
		private function setupGraph():void{
			graph = new Graph(0,10,0,1500,50,350,450,300);			
			graph.drawgrid(1,0.5,500,100);			
			graph.drawaxes('t','p.e., k.e., total');			
			addChild(graph);			
		}
		
		private function setupTimer():void{
			timer = new Timer(100);
			timer.addEventListener(TimerEvent.TIMER,animate);		
			timer.start();
		}		
		
		private function setupArrays():void{
			var t:Number;		
			var v:Number;
			var m:Number = ball.mass;
			for (var i:uint=0; i<=100; i++){
				tA[i] = i*0.1;
				t = tA[i];
				v = u - g*t; 
				hA[i] = u*t - 0.5*g*t*t;
				peA[i] = m*g*hA[i];
				keA[i] = 0.5*m*v*v;
				teA[i] = peA[i] + keA[i];
			}			
		}
		
		private function animate(evt:TimerEvent):void{
			ball.y = groundLevel-hA[n];
			graph.plot([tA[n]], [peA[n]], 0xff0000, true, false);			
			graph.plot([tA[n]], [keA[n]], 0x0000ff, true, false);			
			graph.plot([tA[n]], [teA[n]], 0x000000, true, false);
			evt.updateAfterEvent();			
			n++;
			if (n==hA.length){
				timer.stop();
				timer.removeEventListener(TimerEvent.TIMER,animate);				
			}
		}		
		
	}
}