package{
	import flash.display.Sprite;
	
	public class GradientFunction extends Sprite{
		
		private var numPoints:uint=1001;
		private var numGrad:uint=50;		
		private var xRange:Number=6;
		private var xStep:Number;
		
		public function GradientFunction(){
			init();
		}
		private function init():void{
			var graph:Graph = new Graph(-4,4,-10,10,275,210,450,350);			
			graph.drawgrid(1,0.2,2,0.5);			
			graph.drawaxes('x','y');
			addChild(graph);
			var xA:Array = new Array();
			var yA:Array = new Array();
			// oblicza funkcję
			xStep = xRange/(numPoints-1);
			for (var i:uint=0; i<numPoints; i++){
				xA[i] = (i-numPoints/2)*xStep;
				yA[i] = f(xA[i]);						   
			}
			graph.plot(xA,yA,0xff0000,false,true); // funkcja rysująca wykres
			// oblicza pochodną metodą różnic przednich
			var xAr:Array = new Array();			
			var gradA:Array = new Array();
			for (var j:uint=0; j<numPoints-numGrad; j++){
				xAr[j] = xA[j];
				gradA[j] = grad(xA[j],xA[j+numGrad]);						   
			}
			graph.plot(xAr,gradA,0x0000ff,false,true); // funkcja rysująca wykres pochodnej
			// calculate gradient function using centered method
			var xArc:Array = new Array();			
			var gradAc:Array = new Array();
			for (var k:uint=numGrad; k<numPoints-numGrad; k++){
				xArc[k-numGrad] = xA[k];
				gradAc[k-numGrad] = grad(xA[k-numGrad],xA[k+numGrad]);
			}
			graph.plot(xArc,gradAc,0x00ff00,false,true); // funkcja rysująca wykres pochodnej				
		}
		private function f(x:Number):Number{
			var y:Number;
			y = x*x;
			return y;
		}
		private function grad(x1:Number,x2:Number):Number{
			return (f(x1)-f(x2))/(x1-x2);
		}				
	}
}