package {
	import com.physicscodes.math.Graph;
	import com.physicscodes.math.Vector2D;
	import com.physicscodes.motion.ForcerIntegrator;
	import com.physicscodes.motion.Forces;
	import com.physicscodes.objects.Particle;			

	public class Orbiter extends ForcerIntegrator{
		private var _orbiter:Particle;				
		private var _massOrbiter:Number;
		private var _massAttractor:Number;		
		private var _center:Vector2D;
		private var _graph:Graph;		
		private var _stageWidth:Number;
		private var _stageHeight:Number;		
		private var _G:Number = 1;

		public function Orbiter(porbiter:Particle,pattractor:Particle):void{
			_orbiter = porbiter;
			_massOrbiter = porbiter.mass;			
			_massAttractor = pattractor.mass;			
			_center = pattractor.pos2D;
			_stageWidth = _orbiter.stage.stageWidth;			
			_stageHeight = _orbiter.stage.stageHeight;				
			setupGraph();		
			super(porbiter);
		}	
		
		override protected function calcForce(ppos:Vector2D,pvel:Vector2D):void{
			//force = Forces.gravity(_G,_massAttractor,_massOrbiter,_orbiter.pos2D.subtract(_center));		
			force = Forces.gravity(_G,_massAttractor,_massOrbiter,ppos.subtract(_center));	
		}
	
		override protected function moveObject():void{
			super.moveObject();
			plotGraph();		
		}	
		
		private function setupGraph():void {
			//_graph= new Graph(xmin,xmax,ymin,ymax,xorig,yorig,xwidth,ywidth);	
			_graph= new Graph(0,_stageWidth,0,_stageHeight,0,0,_stageWidth,_stageHeight);						
			_orbiter.stage.addChild(_graph);
		}
		private function plotGraph():void{
			_graph.plot([_orbiter.xpos], [-_orbiter.ypos], 0xcccccc, false, true);		
		}				
		
	}
}
