﻿package com.physicscodes.objects {
	import flash.display.Sprite;
	public class Bar extends Sprite {
		private var _x:Number;
		private var _y:Number;
		private var _width:Number;
		private var _height:Number;		
		private var _color:uint;
		private var _level:Sprite=new Sprite();

		public function Bar(px:Number=0,py:Number=0,pwidth:Number=4, pheight:Number=4,pcolor:uint=0xff0000) {
			_x = px;
			_y = py;
			_width = pwidth;
			_height = pheight;
			_color = pcolor;
			init();
		}
		private function init():void {
			drawFrame();
			drawLevel();
			setLevel(1);
		}
		private function drawLevel():void{	
			with (_level.graphics){
				beginFill(_color,1);
				drawRect(_x+1,_y,_width-1,-_height);
				endFill();
			}
			addChild(_level);
		}
		
		public function setLevel(pfrac:Number):void{
			_level.height *= pfrac;
			_level.y = _y + _height - _level.height/2;
		}
		
		private function drawFrame():void{			
			with (this.graphics){
				lineStyle(1,0x666666,1);			
				drawRect(_x,_y,_width,_height);
			}
		}		
		
	}
}