package {
	import com.physicscodes.motion.MultiForcer;
	import com.physicscodes.motion.Forces;	
	import com.physicscodes.math.Vector2D;	
	import com.physicscodes.objects.Particle;	
	import com.physicscodes.objects.Star;		

	public class GalaxyMover extends MultiForcer{
		private var _massAttractor:Number;		
		private var _radiusAttractor:Number;		
		private var _center:Vector2D;
		private var _orbiters:Array;
		private var _massStars:Array=new Array(); // łączna masa gwiazd znajdujących się w odległości r od środka układu
		private var _massDark:Array=new Array(); // łączna masa ciemnej materii znajdującej się w odległości r od środka układu	
		private var _G:Number = 1;		
		private var _rmax:Number = 500;
		private var _constDark:Number=1000;
		private var _A:Number=1;
		private var _alpha:Number=0.5;
		
		public function GalaxyMover(porbiters:Array,pattractor:Star):void{		
			_massAttractor = pattractor.mass;
			_radiusAttractor = pattractor.radius;			
			_center = pattractor.pos2D;
			_orbiters = porbiters;
			super(porbiters);
		}	
		
		override protected function moveObject():void{
			calcMass();
			super.moveObject();			
		}
		
		override protected function calcForce(porbiter:Particle):void{
			var radius:Vector2D = porbiter.pos2D.subtract(_center);			
			if (radius.length < _radiusAttractor) {
				force=new Vector2D(0,0);
			}
			else{
				force = Forces.gravity(_G,_massAttractor+_massStars[Math.ceil(radius.length)]+_massDark[Math.ceil(radius.length)],porbiter.mass,radius);		
			}
		}
		
		private function calcMass():void{
			var distanceToCenter:Number;
			var orbiter:Particle;
			var massStarRing:Array = new Array();
			var massDarkRing:Array = new Array();
			for (var l:uint=0; l<_rmax; l++){
				massStarRing[l] = 0;
				massDarkRing[l] = _constDark*l*l*Math.exp(-_A*Math.pow(l,_alpha));
			}
			for (var k:uint=0; k<_orbiters.length-1; k++){
				orbiter = _orbiters[k];
				distanceToCenter = orbiter.pos2D.subtract(_center).length;
				massStarRing[Math.ceil(distanceToCenter)] += orbiter.mass; 
			}
			_massStars[0] = massStarRing[0];
			_massDark[0] = massDarkRing[0];
			for(var j:uint=1; j<_orbiters.length-1; j++){
				_massStars[j] = _massStars[j-1] + massStarRing[j]; 
				_massDark[j] = _massDark[j-1] + massDarkRing[j]; 				
			}			
			//trace(_massAttractor,_massStars[_rmax-1],_massDark[_rmax-1]);
		}
		
	}
}
