﻿package {
	import com.physicscodes.motion.MultiForcer;
	import com.physicscodes.motion.Forces;	
	import com.physicscodes.objects.Particle;
	import com.physicscodes.objects.Ball;
	import com.physicscodes.math.Vector2D;	

	public class FieldForcer extends MultiForcer{
				
		private var _centers:Array=new Array();		
		private var _G:Number=1;

		public function FieldForcer(pparticles:Array,pcenters:Array):void{
			_centers = pcenters;
			super(pparticles);
		}	
		
		override protected function calcForce(pparticle:Particle):void{
			var central:Vector2D;
			force = Forces.zeroForce();
			for (var i:uint=0; i<_centers.length; i++){
				var center:Ball=_centers[i];
				var k:Number = -_G*center.mass*pparticle.mass;
				var n:Number = center.charge;
				var r:Vector2D = pparticle.pos2D.subtract(center.pos2D);
				if (r.lengthSquared > Math.pow(center.radius,2)){			
					central = Forces.central(k,n,r);
				}else{
					central = Forces.zeroForce();
				}
				force = Forces.add([force, central]);	
			}
		}
		
	}
}
