/*
SADbot v.03

SADbot będzie rysował w losowym kierunku na losową odległość aż do zasłonięcia 
fotokomórki. Po wykryciu zasłoniętej fotokomórki zacznie rysować w jej stronę. Silniki
krokowe są sterowane modułami EasyDriver v4.3 firmy SparkFun.
Kod oparty na licencji CC-GNU GPL. Autorzy: Ben Leduc-Mills i Dustyn Roberts
Kod stworzony w czerwcu 2010 roku
*/

#include <Stepper.h> //importujemy bibliotekę silnika krokowego

#define STEPS 200 // 360/1.8 (kąt pojedynczego kroku) = 200 kroków/pełen obrotów

//deklarujemy nowe obiekty z biblioteki Stepper.h (po jednym dla każdego silnika)
Stepper right_motor(STEPS, 6, 7); //6=DIR, 7=STEP
Stepper left_motor(STEPS, 11, 12); //11=DIR, 12=STEP

int distance; // jaką odległość mają silniki pokonać
int lowest; // zmienna przechowująca najniższą wartość fotokomórki
int i; // zmienna do pętli

// zmienne dla czterech fotokomórek
int photo_up;
int photo_down;
int photo_left;
int photo_right;

// Ustanawiamy rozmiar arkusza kreślarskiego. 1000 kroków to mniej więcej 1 cm
#define CANVASWIDTH 32000
#define CANVASHEIGHT 20000

//całkowita odległość w celu sprawdzania zakresu
//SADbot zaczyna na środku (canvaswidth/2 i canvasheight/2)
float totalWidth = CANVASWIDTH /2;
float totalHeight = CANVASHEIGHT /2;

int randomDirection;
int randomDistance;

void setup()
{
   Serial.begin(9600); //rozpoczyna wyświetlanie wyników w porcie szeregowym

   // dobieramy szybkości silników (obroty na minutę)
   right_motor.setSpeed(200);
   left_motor.setSpeed(200);

   //wprowadzamy losowe ziarno, aby uzyskać większą losowość
   //*wiążemy ją z nieużywaną nóżką analogową
   randomSeed(analogRead(4));

} // koniec konfiguracji

void loop()
{
   //odczytuje i wyświetla wszystkie wartości fotokomórek z nóżek analogowych 0. – 3.
   photo_up = analogRead(0);
   Serial.print("Gora");
   Serial.println(photo_up);

   photo_down = analogRead(1);
   Serial.print("Dol");
   Serial.println(photo_down);

   photo_left = analogRead(2);
   Serial.print("Lewo");
   Serial.println(photo_left);

   photo_right = analogRead(3);
   Serial.print("Prawo");
   Serial.println(photo_right);

   delay(1000); //czas dla Ciebie na odczytanie wyników

   //przed rozpoczęciem rysowania sprawdza wartości totalHeight i totalWidth
   Serial.print("totalHeight:");
   Serial.println(totalHeight);
   Serial.print("totaWidth:");
   Serial.println(totalWidth);

   delay(1000); //czas dla Ciebie na odczytanie wyników

   //przechowuje wartości fotokomórek w tablicy
   int photoValues[]= {photo_up, photo_down, photo_left, photo_right};

   lowest = 9999; //wartość ta powinna być wyższa od odczytywanych wartości fotokomórek

   //pętla wyszukująca najniższą wartość fotokomórki
   for(i = 0; i < 4; i++) //4 = liczba fotokomórek
      {
      Serial.println(photoValues[i]); //wyświetla tablicę photoValue

      //oznacza rzeczywistą wartość fotokomórki jako „najniższą”, jeżeli jest niższa
      //od domyślnie ustawionej „najniższej” wartości (9999)
      if (lowest >= photoValues[i] )
         {
         lowest = photoValues[i];
         }

      //wyświetla potwierdzenie wybrania najniższej wartości
      Serial.print("Najnizsza:");
      Serial.println(lowest);

      delay(1000); // odczekuje sekundę, żebyś mógł odczytać wartości

      } //koniec pętli for

   distance = lowest; //dobiera zmienną pokonywanej odległości (distance) = najniższa wartość (lowest)

   //jeżeli najniższa wartość oznacza zasłoniętą fotokomórkę, mazak zostaje skierowany w jej stronę
   if (lowest < 550 )
      {
      //znajdź czujnik, którego odczyt ma najniższą wartość, idź w jego kierunku,
      //ale tylko wtedy, gdy SADbot znajduje się na obszarze deski kreślarskiej
      if ((lowest == photoValues[0]) && ((totalHeight + distance) < CANVASHEIGHT))
         {
         up( distance );
         totalHeight += distance; //zwiększa wartość zmiennej totalHeight
         }
      else if ((lowest == photoValues[1]) && ((totalHeight - distance) > 0))
         {
         down( distance );
         totalHeight -= distance; //zmniejsza wartość zmiennej totalHeight
         }
      else if ((lowest == photoValues[2]) && ((totalWidth - distance) > 0))
         {
         left( distance );
         totalWidth -= distance; //zmniejsza wartość zmiennej totalWidth
         }
      else if ((lowest == photoValues[3]) && ((totalWidth + distance) < CANVASWIDTH))
         {
         right( distance );
         totalWidth += distance; //zwiększa wartość zmiennej totalWidth
         }
      } //koniec instrukcji if

      //w przeciwnym wypadku fotokomórki nie są zasłoniete, rysuj więc w losowym kierunku na losową odległość
         {
         //wybiera losową liczbę od 1 do 9 odpowiadające za kierunek
         randomDirection = random(1, 9);
         Serial.print("Losowy kierunek:");
         Serial.println(randomDirection);

         //wybiera losową liczbę od 1 do 200 odpowiadające odległości
         randomDistance = random(1, 200);
         Serial.print("Losowa odleglosc:");
         Serial.println(randomDistance);

         //kierunki dla dowolnej, wygenerowanej wartości randomDirection
         switch (randomDirection)
            {
            case 1: //do góry
               if((totalHeight + randomDistance) < CANVASHEIGHT)
                  {
                  up(randomDistance);
                  totalHeight += randomDistance;
                  }
               break;

            case 2: //w dół
               if((totalHeight - randomDistance) > 0)
                  {
                  down(randomDistance);
                  totalHeight -= randomDistance;
                  }
               break;

            case 3: //w lewo
               if((totalWidth - randomDistance) > 0)
                  {
                  left(randomDistance);
                  totalWidth -= randomDistance;
                  }
               break;

            case 4: //w prawo
               if((totalWidth + randomDistance) < CANVASWIDTH)
                  {
                  right(randomDistance);
                  totalWidth += randomDistance;
                  }
               break;

            case 5: //do góry i w prawo
               if(((totalWidth + randomDistance) < CANVASWIDTH) && ((totalHeight
+ randomDistance) < CANVASHEIGHT))
                  {
                  upRight(randomDistance);
                  totalWidth += randomDistance;
                  totalHeight += randomDistance;
                  }
               break;

            case 6: //do góry i w lewo
               if(((totalWidth - randomDistance) > 0) && ((totalHeight +
randomDistance) < CANVASHEIGHT))
                  {
                  upLeft(randomDistance);
                  totalWidth -= randomDistance;
                  totalHeight += randomDistance;
                  }
               break;

            case 7: //w dół i w prawo
               if(((totalWidth + randomDistance) < CANVASWIDTH) && ((totalHeight
- randomDistance) > 0))
                  {
                  downRight(randomDistance);
                  totalWidth += randomDistance;
                  totalHeight -= randomDistance;
                  }
               break;

            case 8: //w dół i w lewo
               if(((totalWidth - randomDistance) > 0) && ((totalHeight -
randomDistance) > 0))
                  {
                  downLeft(randomDistance);
                  totalWidth -= randomDistance;
                  totalHeight -= randomDistance;
                  }
               break;

         default: //na wszelki wypadek
            left(0);

      } //koniec instrukcji switch

   } //koniec instrukcji warunkowej else

} //koniec pętli

/*
Poniżej znajdują się funkcje odpowiedzialne za ruch w danym kierunku. Rozmiar pętli = pokonywana odległość.
Wartości dodatnie to obrót zgodnie z ruchem wskazówek zegara, ujemne — w przeciwnym kierunku
*/

void up(int distance)
{
   for( i = 0; i < distance; i++) {
      right_motor.step(1);
      left_motor.step(-1);
      }
}

void down(int distance)
{
   for( i = 0; i < distance; i++) {
      right_motor.step(-1);
      left_motor.step(1);
      }
}

void left(int distance)
{
   for( i = 0; i < distance; i++) {
      right_motor.step(-1);
      left_motor.step(-1);
      }
}

void right(int distance)
{
   for( i = 0; i < distance; i++) {
      right_motor.step(1);
      left_motor.step(1);
      }
}

void upRight(int distance)
{
   for( i = 0; i < distance; i++) {
      right_motor.step(2);
      left_motor.step(-.2);
      }
}

void upLeft(int distance)
{
   for( i = 0; i < distance; i++) {
      right_motor.step(.2);
      left_motor.step(-2);
      }
}

void downRight(int distance)
{
   for( i = 0; i < distance; i++) {
      right_motor.step(-.2);
      left_motor.step(2);
      }
}

void downLeft(int distance)
{
   for( i = 0; i < distance; i++) {
      right_motor.step(-2);
      left_motor.step(.2);
      }
}

