/* =================================================
Sterowanie zegarami RTC DS1307, PCF8563
(c)2021 Filip Sala, Marzena Sala-Tefelska
====================================================*/
#include <avr/io.h>
#include "i2c_lib.h"
#include "lcd_lib.h"

void set_time(uint8_t hrs, uint8_t min, uint8_t sec)
{
 I2C_send(ADDR_HRS, ((hrs / 10) << 4) + (hrs % 10)); 
 I2C_send(ADDR_MIN, ((min / 10) << 4) + (min % 10)); 
 I2C_send(ADDR_SEC, ((sec / 10) << 4) + (sec % 10)); 
}

int main (void)
{
 lcd_init();
 I2C_init();
 //set_time(15,29,05); //wpisanie godziny
 while (1)
 {
  uint8_t sec, min, hrs;
  sec = I2C_receive(ADDR_SEC);
  min = I2C_receive(ADDR_MIN);
  hrs = I2C_receive(ADDR_HRS);
  sec = 10 * ((sec & 0x70) >> 4) + (sec & 0x0F);
  min = 10 * ((min & 0x70) >> 4) + (min & 0x0F);
  hrs = 10 * ((hrs & 0x30) >> 4) + (hrs & 0x0F);
  lcd_clear();
  if (hrs < 10) lcd_text("0");
  lcd_integer(hrs);
  if (min < 10) lcd_text(":0"); else lcd_text(":");
  lcd_integer(min);
  if (sec < 10) lcd_text(":0"); else lcd_text(":");
  lcd_integer(sec);
  _delay_ms(1000); 
 }
return 0;
}