/* =================================================
Biblioteka i2c_lib v. 1.0 do sterowania zegarami RTC
(c)2021 Filip Sala, Marzena Sala-Tefelska
====================================================*/
#include "i2c_lib.h"

void I2C_init(void)
{
 TWBR = 4;
 TWSR = (1 << TWPS1) | (1 << TWPS0); 
}

void I2C_start(void)
{
 TWCR = (1 << TWINT) | (1 << TWSTA) | (1 << TWEN); //sygnał START
 while (!(TWCR & (1 << TWINT))); //czekanie na flagę TWINT
}

void I2C_stop(void)
{
 TWCR = (1 << TWINT) | (1 << TWEN) | (1 << TWSTO);
}

static void I2C_write_byte(uint8_t data)
{
 TWDR = data; //umieszczenie danych w rejestrze TWDR
 TWCR = (1 << TWINT) | (1 << TWEN); //wysłanie danych
 while (!(TWCR & (1 << TWINT))); //czekanie na wysłanie danych
}

static uint8_t I2C_read_byte (uint8_t ack)
{
 if (ack)  
 { 
  TWCR = (1 << TWINT) | (1 << TWEA) | (1 << TWEN);
 } else TWCR = (1 << TWINT) | (1 << TWEN);
 while (!(TWCR & (1 << TWINT))); //czekanie na odbiór danych
 return TWDR;
}

void I2C_send (uint8_t addr, uint8_t data)
{
   I2C_start();
   I2C_write_byte(SLA_W); //adres slave + W
   I2C_write_byte(addr);  //adres w pamięci
   I2C_write_byte(data);  //dane które chcemy wysyłać
   I2C_stop();
}

uint8_t I2C_receive (uint8_t addr)
{
   I2C_start();
   I2C_write_byte(SLA_W); //adres slave + W
   I2C_write_byte(addr);  //adres w pamięci
   I2C_start();           //powtórzony start
   I2C_write_byte(SLA_R); //adres slave + R
   uint8_t temp;          //tymczasowa zmienna
   temp = I2C_read_byte(0); //odczyt z sygnałem not acknowledge
   I2C_stop();
   return temp;
}