/* ========================================
Obsługa termometru DS18B20
(c)2021 Filip Sala, Marzena Sala-Tefelska
===========================================*/
#include <avr/io.h>
#include <util/delay.h>
#include "lcd_lib.h"
#include "ow_lib.h"

int main (void)
{
 lcd_init();
 lcd_display_control(1,0,0);
 DS18B20_set_resolution(12); //ustawienie rozdzielczości pomiaru na 12 bitów
 while (1)
 {
  if (!OW_reset())
  {
   OW_write_byte(0xCC); //funkcja skip ROM
   OW_write_byte(0x44); //rozpoczęcie pomiaru temperatury
   while (!OW_read_bit()); //czekamy na koniec konwersji
   OW_reset();
   OW_write_byte(0xCC); //funkcja skip ROM
   OW_write_byte(0xBE); //funkcja read scratchpad (odczyt pamięci)
   uint16_t LSB = OW_read_byte(); //odczyt LSB
   uint16_t MSB = OW_read_byte(); //odczyt MSB
   OW_reset(); //koniec odczytu
   lcd_clear();
   uint16_t value;
   value = ((MSB & 0x07) << 8) +  LSB;
   if (MSB & 0xF0) value =  2048 - value ;  //dla ujemnej temperatury
   uint16_t temperature = value >> 4; // część całkowita, to samo co value/16
   uint32_t frac = ((((uint32_t)value) & 0x0F) * 10000) / 16; //część ułamkowa
   lcd_gotoXY(0,0);
   if (MSB & 0xF0) lcd_text("-"); //ujemna temperatura
   lcd_integer(temperature);
   lcd_text(".");
   if ((value & 0x0F) == 0x01) lcd_text("0");
   lcd_integer(frac);
   lcd_symbol(223); //znak stopni
   lcd_text("C");
   _delay_ms(500); //opóźnienie można pominąć
  } else 
   {
    lcd_gotoXY(0,0);    
    lcd_text("Blad     ");
   }
 }
 return 0;
}
