/* ========================================
Sterowanie diodami LED
(c)2021 Filip Sala, Marzena Sala-Tefelska
===========================================*/
#include <avr/io.h>
#include <util/delay.h>
#define MY_PORT PORTD
#define MY_DDR DDRD

int main (void)
{
 MY_DDR |= 0xFF; //ustawienie kierunku wyjściowego
 while (1)
 {
  MY_PORT = 0x00; //zgaszenie diod
  _delay_ms(500);
  MY_PORT = 0xFF; //zapalenie diod
  _delay_ms(500);
  //liczenie binarne od 0 do 255
  for (uint8_t i = 0;i < 255;i++)
  {
   MY_PORT = i;
   _delay_ms(50);
  }
  //zapalanie po kolei diod
  for (uint8_t i = 0;i <= 7;i++)
  {
   MY_PORT = (1 << i);
   _delay_ms(100);
  }
  for (int8_t i = 7; i >= 0; i--)
  {
   MY_PORT = (1 << i);
   _delay_ms(100);
  }
  for (uint8_t i = 0;i <= 7;i++)
  {
   MY_PORT = (1 << i);
   _delay_ms(100);
  }  
  MY_PORT = 0xAA; //co druga dioda zapalona
  for (uint8_t i = 0;i <= 5;i++)
  {
   MY_PORT ^= 0xFF; //zmiana stanu diod na przeciwny
   _delay_ms(500);
  }
  MY_PORT = 0xFF; //wszystkie diody zapalone
  _delay_ms(500);
    for (uint8_t i = 0;i <= 7;i++)
  {
   MY_PORT &= ~(1 << i); //gaszenie diod po kolei
   _delay_ms(500);
  }
 }
 return 0;
}
