/* ========================================
Sterowanie silnikiem krokowym
(c)2021 Filip Sala, Marzena Sala-Tefelska
===========================================*/
/* ---------------------------------------------
Silnik podłączamy do portu MOTOR_PORT
poprzez odpowiedni stopień mocy np. ULN2003
Przewody podłączamy po kolei do pinów od 0 do 3
na porcie MOTOR_PORT
------------------------------------------------ */
#include <avr/io.h>
#include <util/delay.h>
#define MOTOR_PORT PORTD
#define MOTOR_DDR DDRD
//MOTOR_DELAY - czas trwania jednego kroku
//Dla silnika 28BYJ-48 opóźnienie powinno wynosić powyżej 2-3ms
#define MOTOR_DELAY 15
//DIRECTION - kierunek 0/1 
#define DIRECTION 0

int main (void)
{
 MOTOR_DDR |= 0x0F;
 while (1) 
 { 
  if (DIRECTION)
  {
   for (uint8_t i = 0; i <= 3; i++)
   {
    MOTOR_PORT = (1 << i);
    //MOTOR_PORT = ((3 << i) | ((3 << i) >> 4)) & 0x0F; 
    _delay_ms(MOTOR_DELAY);
   }
   } 
   else
   {
    for (int8_t i = 3; i >= 0; i--)
    {
     MOTOR_PORT = (1 << i);
     //MOTOR_PORT = ((3 << i) | ((3 << i) >> 4)) & 0x0F;
     _delay_ms(MOTOR_DELAY);
    }
   }
 }
 return 0;
}
