/* ===========================================
Sterownik MAX7219 - Wyświetlacze 7-segmentowe
(c)2021 Filip Sala, Marzena Sala-Tefelska
==============================================*/
#include <avr/io.h>
#include <util/delay.h>
#include "spi_lib.h"
//liczba segmentów (modułów) lub linii
#define NUMBER_OF_SEGMENTS 8
//jasność od 0 do 15
#define BRIGHTNESS 5

void MAX7219_send(uint8_t addr, uint8_t data)
{
 CLR_CS;
 SPI_send(addr);
 SPI_send(data);
 SET_CS; 
}

void MAX7219_clear(void)
{
 for (uint8_t i = 0; i < NUMBER_OF_SEGMENTS; i++)
  MAX7219_send(i+1,0x00);
}

int main (void)
{
 SPI_init();
 MAX7219_send(0x0A,BRIGHTNESS); // jasność 
 MAX7219_send(0x0B,(NUMBER_OF_SEGMENTS -1)); // liczba wyświetlaczy lub linii
 MAX7219_send(0x0C,0x01); // włączenie wyświetlacza
 MAX7219_send(0x0F,0x00); // tryb normalny (test  mode: off)
 MAX7219_send(0x09,0xFF); // tryb dekodowania, 0x00 - brak, 0xFF - kodowanie BCD
 for (uint8_t i = 0; i < NUMBER_OF_SEGMENTS; i++) MAX7219_send(i+1,i); //obsługa 8 wyświetlaczy
 while (1)
 { }
 return 0;
}