/* ========================================
Biblioteka lcd_lib v. 1.0
(c)2021 Filip Sala, Marzena Sala-Tefelska
===========================================*/
#include <avr/io.h>
#include <util/delay.h>
#include <stdlib.h>
#include <stdio.h>
#ifndef lcd_lib
#define lcd_lib
//==================================================================
//poniższe definicje można zmieniać
#define LCD_PORT_DDR DDRA
#define LCD_PORT PORTA
#define LCD_RS 0
#define LCD_E 1
#define LCD_D4 2
#define LCD_D5 3
#define LCD_D6 4
#define LCD_D7 5
//dla LCD_FUNCTION_SET = 0x28 mamy 2 rzędy (linie) wyświetlacza
//czcionka 5x8 pixeli, tryb 4 bitowy
//dla =0x20 mielibyśmy jedną linię
#define LCD_FUNCTION_SET 0x28
//==================================================================
//poniższych definicji i deklaracji nie należy zmieniać, ewentualnie 
//z dużą ostrożnością
//dla LCD_DISPLAY_CONTROL = 0x0F mamy włączony ekran i migający kursor
#define LCD_DISPLAY_CONTROL 0x0F
//dla LCD_ENTRY_MODE = 0x06 mamy tryb inkrementacji, bez przesuwania ekranu
#define LCD_ENTRY_MODE 0x06
#define SET_RS LCD_PORT |= (1 << LCD_RS)
#define SET_E LCD_PORT |= (1 << LCD_E)
#define CLR_RS LCD_PORT &= ~(1 << LCD_RS)
#define CLR_E LCD_PORT &= ~(1 << LCD_E)
void lcd_init(void);
void lcd_text(char* str);
void lcd_integer(int16_t value);
void lcd_clear(void);
void lcd_cursor_return(void);
void lcd_gotoXY(uint8_t x, uint8_t y);
void lcd_display_control(uint8_t, uint8_t, uint8_t);
void lcd_define_symbol(uint8_t code, uint8_t* def_char);
void lcd_symbol(uint8_t value);
void lcd_shift_left(void);
void lcd_shift_right(void);
#endif //lcd_lib
