/* ========================================
Wyświetlacz 7-segmentowy v.2
(c)2021 Filip Sala, Marzena Sala-Tefelska
===========================================*/
#include <avr/io.h>
#include <avr/interrupt.h>
#define LED_PORT PORTB
#define LED_DDR DDRB
#define COMMON_PORT PORTD
#define COMMON_DDR DDRD
volatile uint16_t display[4] = {0,0,0,0}; // wyświetlane cyfry 
volatile uint8_t digit[10] ={0xC0,0xF9,0xA4,0xB0,0x99,0x92,0x82,
0xF8,0x80,0x90};
volatile uint16_t time;

ISR(TIMER0_COMP_vect)
{
 //konwersja time na minuty:sekundy
 display[3] = time / 600;
 display[2] = time % 600;
 display[1] = display[2] % 60;
 display[0] = display[1] % 10;
 display[2] /= 60;
 display[1] /= 10;
 static uint8_t com = 0;
 com++;
 if (com >= 4) com = 0; 
 COMMON_PORT = ~(1 << com);
 LED_PORT = digit[display[com]];
 if ((com == 2) && (time % 2)) LED_PORT &= ~(1 << 7); //miganie kropki
 //if ((com == 2)) LED_PORT &= ~(1 << 7); //świecenie się kropki na pozycji 2
}

ISR(TIMER1_COMPA_vect)
{ 
 time++;
}

int main (void)
{
  // Timer0  
 TCCR0 |= (1 << WGM01); //tryb CTC Timer0
 TCCR0 |= (1 << CS01) | (1 << CS00); //dzielnik 64
 OCR0 = 77; // ustawienie rejestru porównania
 TIMSK |= (1 << OCIE0); //włączenie obsługi przerwania
 // Timer 1 (dzielniki i rejestry porównania dla F_CPU = 1MHz)
 TCCR1B |= (1 << WGM12); //tryb CTC
 TCCR1B |= (1 << CS10) | (1 << CS11); // dzielnik 64
 OCR1A = 15624; // podstawienie rejestru porównania
 TIMSK |= (1 << OCIE1A); //dla ATmega8/16/32
 COMMON_DDR = 0x0F;
 LED_DDR = 0xFF;
 sei();
 while (1){  }
 return 0;
}

/*
// Alternatywne rozwiązania
// zliczanie sekund
display[3] = time / 1000;
display[2] = (time - display[3] * 1000) / 100;
display[1] = (time - display[3] * 1000 - display[2] * 100) / 10;
display[0] = time - display[3] * 1000 - display[2] * 100 
- display[1] * 10;

//minuty:sekundy
display[3] = time / 600;
display[2] = (time - display[3] * 600) / 60 ;
display[1] = (time - display[3] * 600 - display[2] * 60) / 10;
display[0] = time - display[3] * 600 - display[2] * 60 
- display[1] * 10;

// zliczanie sekund,  jednak wtedy display[] musi być przynajmniej typu uint16_t
 display[3] = time / 1000;
 display[2] = time % 1000;
 display[1] = display[2] % 100;
 display[0] = display[1] % 10;
 display[2] /= 100;
 display[1] /= 10;

 //zliczanie minuty:sekundy
 display[3] = time / 600;
 display[2] = time % 600;
 display[1] = display[2] % 60;
 display[0] = display[1] % 10;
 display[2] /= 60;
 display[1] /= 10;
*/