import java.io.*;

public class TestRandomAccessFile {
  public static void main(String[] args) throws IOException {
    try ( // Tworzenie obiektu typu RandomAccessFile
      RandomAccessFile inout = new RandomAccessFile("inout.dat", "rw");
    ) {
      // Opróżnianie pliku, aby usunąć dawne dane, jeśli istnieją
      inout.setLength(0);
  
      // Zapis nowych liczb całkowitych w pliku
      for (int i = 0; i < 200; i++)
        inout.writeInt(i);
  
      // Wyświetlanie aktualnej długości pliku
      System.out.println("Aktualna długość pliku: " + inout.length());
  
      // Pobieranie pierwszej liczby
      inout.seek(0); // Przesuwanie kursora na początek
      System.out.println("Pierwsza liczba: " + inout.readInt());
  
      // Pobieranie drugiej liczby
      inout.seek(1 * 4); // Przesuwanie kursora na drugą liczbę
      System.out.println("Druga liczba: " + inout.readInt());
  
      // Pobieranie dziesiątej liczby
      inout.seek(9 * 4); // Przesuwanie kursora na dziesiątą liczbę
      System.out.println("Dziesiąta liczba: " + inout.readInt());
  
      // Modyfikowanie jedenastej liczby
      inout.writeInt(555);
  
      // Dodawanie nowej liczby
      inout.seek(inout.length()); // Przesuwanie kursora na koniec pliku
      inout.writeInt(999);
  
      // Wyświetlanie nowej długości
      System.out.println("Nowa długość: " + inout.length());
  
      // Pobieranie nowej jedenastej liczby
      inout.seek(10 * 4); // Przenoszenie kursora na jedenastą liczbę
      System.out.println("Jedenasta liczba: " + inout.readInt());
    }
  }
}
