import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.stage.Stage;

public class RotateDemo extends Application {
  @Override // Przesłanianie metody start z klasy Application
  public void start(Stage primaryStage) {   
    Pane pane = new Pane();
    java.util.Random random = new java.util.Random();
    // Promień koła do wyznaczania pozycji prostokątów
    double radius = 90; 
    double width = 20; // Szerokość prostokąta
    double height = 40; // Wysokość prostokąta
    for (int i = 0; i < 8; i++) {
      // Środek prostokąta
      double x = 150 + radius * Math.cos(i * 2 * Math.PI / 8);
      double y = 150 + radius * Math.sin(i * 2 * Math.PI / 8);              
      Rectangle rectangle = new Rectangle(
        x - width / 2, y - height / 2, width, height);  
      rectangle.setFill(Color.WHITE);
      rectangle.setStroke(Color.color(random.nextDouble(), 
        random.nextDouble(), random.nextDouble()));
      rectangle.setRotate(i * 360 / 8); // Rotowanie prostokąta
      pane.getChildren().add(rectangle);
    }

    Scene scene = new Scene(pane, 300, 300);           
    primaryStage.setTitle("RotateDemo"); // Ustawianie nagłówka okna
    primaryStage.setScene(scene); // Umieszczanie sceny w oknie
    primaryStage.show(); // Wyświetlanie okna
  }

  // Uruchom program w wierszu poleceń
  public static void main(String[] args) {
    launch(args);
  }
}


