import java.util.Comparator;

public class HeapSort {
  /** Metoda heapSort */
  public static <E> void heapSort(E[] list) {
    // Tworzenie kopca liczb całkowitych
    heapSort(list, (e1, e2) -> ((Comparable<E>)e1).compareTo(e2));
  }
  
  /** Metoda heapSort */
  public static <E> void heapSort(E[] list, Comparator<E> c) {
    // Tworzenie kopca liczb całkowitych
    Heap<E> heap = new Heap<>(c);

    // Dodawanie elementów do kopca
    for (int i = 0; i < list.length; i++)
      heap.add(list[i]);

    // Usuwanie elementów z kopca
    for (int i = list.length - 1; i >= 0; i--)
      list[i] = heap.remove();
  }

  /** Metoda testowa */
  public static void main(String[] args) {
    Integer[] list = {-44, -5, -3, 3, 3, 1, -4, 0, 1, 2, 4, 5, 53}; 
    heapSort(list);
    for (int i = 0; i < list.length; i++)
      System.out.print(list[i] + " ");
  }
}
