import javafx.application.Application;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.stage.Stage;
import javafx.geometry.Pos;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;

public class FlagAnthem extends Application {
  private final static int NUMBER_OF_NATIONS = 7;
  private final static String URLBase =
    "https://liveexample.pearsoncmg.com/common";
  private int currentIndex = 0;
    
  @Override // Przesłanianie metody start z klasy Application
  public void start(Stage primaryStage) {
    Image[] images = new Image[NUMBER_OF_NATIONS];
    MediaPlayer[] mp = new MediaPlayer[NUMBER_OF_NATIONS];

    // Wczytywanie obrazów i nagrań
    for (int i = 0; i < NUMBER_OF_NATIONS; i++) {
      images[i] = new Image(URLBase + "/image/flag" + i + ".gif");
      mp[i] = new MediaPlayer(new Media(
        URLBase + "/audio/anthem/anthem" + i + ".mp3"));
    }

    Button btPlayPause = new Button("||");
    btPlayPause.setOnAction(e -> {
      if (btPlayPause.getText().equals(">")) {
        btPlayPause.setText("||");
        mp[currentIndex].play();
      } 
      else {
        btPlayPause.setText(">");
        mp[currentIndex].pause();
      }
    });

    ImageView imageView = new ImageView(images[currentIndex]);   
    ComboBox<String> cboNation = new ComboBox<>();
    ObservableList<String> items = FXCollections.observableArrayList
      ("Dania", "Niemcy", "Chiny", "Indie", "Norwegia", "Wielka Brytania", "USA");
    cboNation.getItems().addAll(items);
    cboNation.setValue(items.get(0));
    cboNation.setOnAction(e -> {
      mp[currentIndex].stop();
      currentIndex = items.indexOf(cboNation.getValue());
      imageView.setImage(images[currentIndex]);
      mp[currentIndex].play();
      btPlayPause.setText("||");
    });

    HBox hBox = new HBox(10);
    hBox.getChildren().addAll(btPlayPause, 
      new Label("Wybierz kraj: "), cboNation);
    hBox.setAlignment(Pos.CENTER);

    // Tworzenie panelu do przechowywania węzłów
    BorderPane pane = new BorderPane();
    pane.setCenter(imageView);
    pane.setBottom(hBox);

    // Tworzenie sceny i umieszczanie jej w oknie
    Scene scene = new Scene(pane, 350, 270);
    primaryStage.setTitle("FlagAnthem"); // Ustawianie nagłówka okna
    primaryStage.setScene(scene); // Umieszczanie sceny w oknie
    primaryStage.show(); // Wyświetlanie okna
    mp[currentIndex].play(); // Odtwarzanie hymnu wybranego kraju
  }

  /**
   * Metoda main jest potrzebna tylko w środowiskach IDE z ograniczoną obsługą platformy JavaFX.
   * Nie jest potrzebna przy uruchamianiu kodu w wierszu poleceń.
   */
  public static void main(String[] args) {
    launch(args);
  }
}
