import java.util.concurrent.*;
import java.util.concurrent.locks.*;

public class ConsumerProducer {
  private static Buffer buffer = new Buffer();

  public static void main(String[] args) {
    // Tworzenie puli z dwoma wątkami
    ExecutorService executor = Executors.newFixedThreadPool(2);
    executor.execute(new ProducerTask());
    executor.execute(new ConsumerTask());
    executor.shutdown();
  }

  // Zadanie dodające liczbę do bufora
  private static class ProducerTask implements Runnable {
    public void run() {
      try {
        int i = 1;
        while (true) {
          System.out.println("Producent zapisał " + i);
          buffer.write(i++); // Dodawanie wartości do bufora
          // Usypianie wątku
          Thread.sleep((int)(Math.random() * 10000));
        }
      } 
      catch (InterruptedException ex) {
        ex.printStackTrace();
      }
    }
  }

  // Zadanie wczytujące i usuwające liczbę z bufora
  private static class ConsumerTask implements Runnable {
    public void run() {
      try {
        while (true) {
          System.out.println("\t\t\tKonsument wczytał " + buffer.read());
          // Usypianie wątku
          Thread.sleep((int)(Math.random() * 10000));
        }
      } 
      catch (InterruptedException ex) {
        ex.printStackTrace();
      }
    }
  }

  // Klasa wewnętrzna Buffer
  private static class Buffer {
    private static final int CAPACITY = 1; // Wielkość bufora
    private java.util.LinkedList<Integer> queue =
      new java.util.LinkedList<>();

    // Tworzenie nowej blokady
    private static Lock lock = new ReentrantLock();

    // Tworzenie dwóch warunków
    private static Condition notEmpty = lock.newCondition();
    private static Condition notFull = lock.newCondition();

    public void write(int value) {
      lock.lock(); // Zajmowanie blokady
      try {
        while (queue.size() == CAPACITY) {
          System.out.println("Oczekiwanie na warunek notFull");
          notFull.await();
        }

        queue.offer(value);
        notEmpty.signal(); // Sygnalizowanie warunku notEmpty
      } 
      catch (InterruptedException ex) {
        ex.printStackTrace();
      } 
      finally {
        lock.unlock(); // Zwalnianie blokady
      }
    }

    public int read() {
      int value = 0;
      lock.lock(); // Zajmowanie blokady
      try {
        while (queue.isEmpty()) {
          System.out.println("\t\t\tOczekiwanie na warunek notEmpty");
          notEmpty.await();
        }

        value = queue.remove();
        notFull.signal(); // Sygnalizowanie warunku notFull
      } 
      catch (InterruptedException ex) {
        ex.printStackTrace();
      } 
      finally {
        lock.unlock(); // Zwalnianie blokady
        return value;
      }
    }
  }
}
