public class TestGraph {
  public static void main(String[] args) {
    String[] vertices = {"Seattle", "San Francisco", "Los Angeles",
      "Denver", "Kansas City", "Chicago", "Boston", "Nowy Jork",
      "Atlanta", "Miami", "Dallas", "Houston"};

    // Tablica krawędzi dla grafu z rysunku 28.1
    int[][] edges = {
      {0, 1}, {0, 3}, {0, 5},
      {1, 0}, {1, 2}, {1, 3},
      {2, 1}, {2, 3}, {2, 4}, {2, 10},
      {3, 0}, {3, 1}, {3, 2}, {3, 4}, {3, 5},
      {4, 2}, {4, 3}, {4, 5}, {4, 7}, {4, 8}, {4, 10},
      {5, 0}, {5, 3}, {5, 4}, {5, 6}, {5, 7},
      {6, 5}, {6, 7},
      {7, 4}, {7, 5}, {7, 6}, {7, 8},
      {8, 4}, {8, 7}, {8, 9}, {8, 10}, {8, 11},
      {9, 8}, {9, 11},
      {10, 2}, {10, 4}, {10, 8}, {10, 11},
      {11, 8}, {11, 9}, {11, 10}
    };

    Graph<String> graph1 = new UnweightedGraph<>(vertices, edges);
    System.out.println("Liczba wierzchołków w grafie graph1: "
      + graph1.getSize());
    System.out.println("Wierzchołek o indeksie 1: "
      + graph1.getVertex(1));
    System.out.println("Indeks wierzchołka Miami: " + 
      graph1.getIndex("Miami"));
    System.out.println("Krawędzie grafu graph1:");
    graph1.printEdges();

    // Lista obiektów typu Edge dla grafu z rysunku 28.3a
    String[] names = {"Piotr", "Janina", "Marek", "Cecylia", "Wanda"};
    java.util.ArrayList<Edge> edgeList
      = new java.util.ArrayList<>();
    edgeList.add(new Edge(0, 2));
    edgeList.add(new Edge(1, 2));
    edgeList.add(new Edge(2, 4));
    edgeList.add(new Edge(3, 4));
    // Tworzenie grafu o pięciu wierzchołkach
    Graph<String> graph2 = new UnweightedGraph<>
      (java.util.Arrays.asList(names), edgeList);
    System.out.println("\nLiczba wierzchołków w grafie graph2: "
      + graph2.getSize());
    System.out.println("Krawędzie grafu graph2:");
    graph2.printEdges();
  }
}
