import javafx.application.Application;
import javafx.geometry.Insets;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;

public class ShowHBoxVBox extends Application {
  @Override // Przesłanianie metody start z klasy Application
  public void start(Stage primaryStage) {
    // Tworzenie panelu BorderPane
    BorderPane pane = new BorderPane();

    // Umieszczanie węzłów w panelu
    pane.setTop(getHBox()); 
    pane.setLeft(getVBox());
    
    // Tworzenie sceny i umieszczanie jej w oknie
    Scene scene = new Scene(pane);
    primaryStage.setTitle("ShowHBoxVBox"); // Ustawianie nagłówka okna
    primaryStage.setScene(scene); // Umieszczanie sceny w oknie
    primaryStage.show(); // Wyświetlanie okna
  }
  
  private HBox getHBox() {
    HBox hBox = new HBox(15); 
    hBox.setPadding(new Insets(15, 15, 15, 15));
    hBox.setStyle("-fx-background-color: gold");
    hBox.getChildren().add(new Button("Informatyka"));
    hBox.getChildren().add(new Button("Chemia"));
    ImageView imageView = new ImageView(new Image("image/us.gif"));
    hBox.getChildren().add(imageView);
    return hBox;
  }
  
  private VBox getVBox() {
    VBox vBox = new VBox(15); 
    vBox.setPadding(new Insets(15, 5, 5, 5));
    vBox.getChildren().add(new Label("Kursy"));
    
    Label[] courses = {new Label("CSCI 1301"), new Label("CSCI 1302"), 
        new Label("CSCI 2410"), new Label("CSCI 3720")};

    for (Label course: courses) {
      VBox.setMargin(course, new Insets(0, 0, 0, 15));
      vBox.getChildren().add(course);
    }
    
    return vBox;
  }
  
  /**
   * Metoda main jest potrzebna tylko w środowiskach IDE z ograniczoną obsługą platformy JavaFX.
   * Nie jest potrzebna przy uruchamianiu kodu w wierszu poleceń.
   */
  public static void main(String[] args) {
    launch(args);
  }
} 
