import java.io.*;
import java.net.*;
import java.util.Date;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.Scene;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextArea;
import javafx.stage.Stage;

public class Server extends Application {
  @Override // Przesłanianie metody start z klasy Application
  public void start(Stage primaryStage) {
    // Obszar tekstowy do wyświetlania informacji
    TextArea ta = new TextArea();

    // Tworzenie sceny i umieszczanie jej w oknie
    Scene scene = new Scene(new ScrollPane(ta), 450, 200);
    primaryStage.setTitle("Server"); // Ustawianie nagłówka okna
    primaryStage.setScene(scene); // Umieszczanie sceny w oknie
    primaryStage.show(); // Wyświetlanie okna
    
    new Thread( () -> {
      try {
        // Tworzenie gniazda serwera
        ServerSocket serverSocket = new ServerSocket(8000);
        Platform.runLater(() ->
          ta.appendText("Czas uruchomienia serwera: " + new Date() + '\n'));
  
        // Oczekiwanie na żądanie nawiązania połączenia
        Socket socket = serverSocket.accept();
  
        // Tworzenie strumieni wejściowego i wyjściowego 
        DataInputStream inputFromClient = new DataInputStream(
          socket.getInputStream());
        DataOutputStream outputToClient = new DataOutputStream(
          socket.getOutputStream());
  
        while (true) {
          // Przyjmowanie promienia od klienta
          double radius = inputFromClient.readDouble();
  
          // Obliczanie powierzchni
          double area = radius * radius * Math.PI;
  
          // Przesyłanie powierzchni do klienta
          outputToClient.writeDouble(area);
  
          Platform.runLater(() -> {
            ta.appendText("Promień od klienta: " 
              + radius + '\n');
            ta.appendText("Powierzchnia: " + area + '\n'); 
          });
        }
      }
      catch(IOException ex) {
        ex.printStackTrace();
      }
    }).start();
  }

  /**
   * Metoda main jest potrzebna tylko w środowiskach IDE z ograniczoną obsługą platformy JavaFX.
   * Nie jest potrzebna przy uruchamianiu kodu w wierszu poleceń.
   */
  public static void main(String[] args) {
    launch(args);
  }
}
