import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.layout.Pane;
import javafx.scene.shape.Line;
import javafx.scene.text.Text;
import javafx.scene.shape.Polyline;
import javafx.stage.Stage;

public class ScaleDemo extends Application {
  @Override // Przesłanianie metody start w klasie Application
  public void start(Stage primaryStage) {  
    // Tworzenie obiektu typu Polyline w celu narysowania wykresu funkcji sinus
    Polyline polyline = new Polyline();
    for (double angle = -360; angle <= 360; angle++) {
      polyline.getPoints().addAll(
        angle, Math.sin(Math.toRadians(angle)));
    }
    polyline.setTranslateY(100);
    polyline.setTranslateX(200);
    polyline.setScaleX(0.5);
    polyline.setScaleY(50); 
    polyline.setStrokeWidth(1.0 / 25);
    
    // Rysowanie osi x
    Line line1 = new Line(10, 100, 420, 100);
    Line line2 = new Line(420, 100, 400, 90);
    Line line3 = new Line(420, 100, 400, 110);

    // Rysowanie osi y
    Line line4 = new Line(200, 10, 200, 200);
    Line line5 = new Line(200, 10, 190, 30);
    Line line6 = new Line(200, 10, 210, 30);

    // Rysowanie etykiet na osiach x i y
    Text text1 = new Text(380, 70, "X");
    Text text2 = new Text(220, 20, "Y");    
    
    // Dodawanie węzłów do panelu
    Pane pane = new Pane();
    pane.getChildren().addAll(polyline, line1, line2, line3, line4,
      line5, line6, text1, text2);

    Scene scene = new Scene(pane, 450, 200);           
    primaryStage.setTitle("ScaleDemo"); // Ustawianie nagłówka okna
    primaryStage.setScene(scene); // Umieszczanie sceny w oknie
    primaryStage.show(); // Wyświetlanie okna
  }

  // Uruchom program w wierszu poleceń
  public static void main(String[] args) {
    launch(args);
  }
}


