public class PrimeNumberMethod {
  public static void main(String[] args) {
    System.out.println("Początkowych 50 liczb pierwszych to: \n");
    printPrimeNumbers(50);
  }

  public static void printPrimeNumbers(int numberOfPrimes) {
    final int NUMBER_OF_PRIMES_PER_LINE = 10; // Wyświetlanie 10 liczb na wiersz
    int count = 0; // Zliczanie liczb pierwszych
    int number = 2; // Liczba sprawdzana, czy jest liczbą pierwszą

    // Wielokrotne znajdowanie liczb pierwszych
    while (count < numberOfPrimes) {
      // Wyświetlanie liczby pierwszej i zwiększanie wartości licznika
      if (isPrime(number)) {
        count++; // Zwiększanie wartości licznika

        if (count % NUMBER_OF_PRIMES_PER_LINE == 0) {
          // Wyświetlanie liczby i przejście do następnego wiersza
          System.out.printf("%-5d\n", number);
        }
        else
          System.out.printf("%-5d", number);
      }

      // Sprawdzanie, czy następna liczba jest pierwsza
      number++;
    }
  }

  /** Sprawdzanie, czy liczba jest pierwsza */
  public static boolean isPrime(int number) {
    for (int divisor = 2; divisor <= number / 2; divisor++) {
      if (number % divisor == 0) { // Jeśli warunek ma wartość true, liczba nie jest pierwsza
        return false; // Liczba nie jest pierwsza
      }
    }

    return true; // Liczba jest pierwsza
  }
}
