public class Loan {
  private double annualInterestRate;
  private int numberOfYears;
  private double loanAmount;
  private java.util.Date loanDate;

  /** Konstruktor domyślny */
  public Loan() {
    this(2.5, 1, 1000);
  }

  /** Tworzenie kredytu o określonym oprocentowaniu,
      czasie spłacania i kwocie
    */
  public Loan(double annualInterestRate, int numberOfYears,
      double loanAmount) {
    this.annualInterestRate = annualInterestRate;
    this.numberOfYears = numberOfYears;
    this.loanAmount = loanAmount;
    loanDate = new java.util.Date();
  }

  /** Zwraca wartość pola annualInterestRate */
  public double getAnnualInterestRate() {
    return annualInterestRate;
  }

  /** Ustawia nową wartość pola annualInterestRate */
  public void setAnnualInterestRate(double annualInterestRate) {
    this.annualInterestRate = annualInterestRate;
  }

  /** Zwraca wartość pola numberOfYears */
  public int getNumberOfYears() {
    return numberOfYears;
  }

  /** Ustawia nową wartość pola numberOfYears */
  public void setNumberOfYears(int numberOfYears) {
    this.numberOfYears = numberOfYears;
  }

  /** Zwraca wartość pola loanAmount */
  public double getLoanAmount() {
    return loanAmount;
  }

  /** Ustawia nową wartość pola loanAmount */
  public void setLoanAmount(double loanAmount) {
    this.loanAmount = loanAmount;
  }

  /** Oblicza miesięczną ratę */
  public double getMonthlyPayment() {
    double monthlyInterestRate = annualInterestRate / 1200;
    double monthlyPayment = loanAmount * monthlyInterestRate / (1 -
      (1 / Math.pow(1 + monthlyInterestRate, numberOfYears * 12)));
    return monthlyPayment;    
  }

  /** Oblicza łączną kwotę do spłaty */
  public double getTotalPayment() {
    double totalPayment = getMonthlyPayment() * numberOfYears * 12;
    return totalPayment;    
  }

  /** Zwraca datę utworzenia kredytu */
  public java.util.Date getLoanDate() {
    return loanDate;
  }
}
