public abstract class GeometricObject {
  private String color = "biały";
  private boolean filled;
  private java.util.Date dateCreated;

  /** Tworzy domyślny obiekt typu GeometricObject */
  protected GeometricObject() {
    dateCreated = new java.util.Date();
  }

  /** Tworzy obiekt geometryczny z kolorem i informacją o wypełnieniu */
  protected GeometricObject(String color, boolean filled) {
    dateCreated = new java.util.Date();
    this.color = color;
    this.filled = filled;
  }

  /** Zwraca kolor */
  public String getColor() {
    return color;
  }

  /** Ustawia nowy kolor */
  public void setColor(String color) {
    this.color = color;
  }

  /** Zwraca wartość pola filled. Ponieważ jest to wartość logiczna,
   *  nazwa tego gettera to isFilled */
  public boolean isFilled() {
    return filled;
  }

  /** Ustawia nową wartość pola filled */
  public void setFilled(boolean filled) {
    this.filled = filled;
  }

  /** Zwraca wartość pola dateCreated */
  public java.util.Date getDateCreated() {
    return dateCreated;
  }

  /** Zwraca tekstową reprezentację danego obiektu */
  @Override
  public String toString() {
    return "Data utworzenia: " + dateCreated + "\n. Kolor: " + color +
      ". Wypełnienie: " + filled;
  }

  /** Abstrakcyjna metoda getArea */
  public abstract double getArea();

  /** Abstrakcyjna metoda getPerimeter */
  public abstract double getPerimeter();
}