import java.util.concurrent.*;

public class ConsumerProducerUsingBlockingQueue {
  private static ArrayBlockingQueue<Integer> buffer =
    new ArrayBlockingQueue<>(2);

  public static void main(String[] args) {
    // Tworzenie puli z dwoma wątkami
    ExecutorService executor = Executors.newFixedThreadPool(2);
    executor.execute(new ProducerTask());
    executor.execute(new ConsumerTask());
    executor.shutdown();
  }

  // Zadanie dodające liczby całkowite do bufora
  private static class ProducerTask implements Runnable {
    public void run() {
      try {
        int i = 1;
        while (true) {
          System.out.println("Producent zapisuje " + i);
          buffer.put(i++); // Dodawanie do bufora wartości (na przykład 1)
          // Usypianie wątku
          Thread.sleep((int)(Math.random() * 10000));
        }
      } 
      catch (InterruptedException ex) {
        ex.printStackTrace();
      }
    }
  }

  // Zadanie wczytujące i usuwające liczbę całkowitą z bufora
  private static class ConsumerTask implements Runnable {
    public void run() {
      try {
        while (true) {
          System.out.println("\t\t\tKonsument wczytuje " + buffer.take());
          // Usypianie wątku
          Thread.sleep((int)(Math.random() * 10000));
        }
      } 
      catch (InterruptedException ex) {
        ex.printStackTrace();
      }
    }
  }
}
