import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.text.Text;
import javafx.stage.Stage;

public class AnonymousHandlerDemo extends Application {
  @Override // Przesanianie metody start z klasy Application
  public void start(Stage primaryStage) {
    Text text = new Text(40, 40, "Programowanie to przyjemno");
    Pane pane = new Pane(text);

    // HBox zawiera cztery przyciski
    Button btUp = new Button("W gr");
    Button btDown = new Button("W d");
    Button btLeft = new Button("W lewo");
    Button btRight = new Button("W prawo");
    HBox hBox = new HBox(btUp, btDown, btLeft, btRight);
    hBox.setSpacing(10);
    hBox.setAlignment(Pos.CENTER);

    BorderPane borderPane = new BorderPane(pane);
    borderPane.setBottom(hBox);

    // Tworzenie i rejestrowanie metody obsugi zdarze
    btUp.setOnAction(new EventHandler<ActionEvent>() {
      @Override // Przesanianie metody handle
      public void handle(ActionEvent e) {
        text.setY(text.getY() > 10 ? text.getY() - 5 : 10);
      }
    });

    btDown.setOnAction(new EventHandler<ActionEvent>() {
      @Override // Przesanianie metody handle
      public void handle(ActionEvent e) {
        text.setY(text.getY() < pane.getHeight() ?
          text.getY() + 5 : pane.getHeight());
      }
    });

    btLeft.setOnAction(new EventHandler<ActionEvent>() {
      @Override // Przesanianie metody handle
      public void handle(ActionEvent e) {
        text.setX(text.getX() > 0 ? text.getX() - 5 : 0);
      }
    });

    btRight.setOnAction(new EventHandler<ActionEvent>() {
      @Override // Przesanianie metody handle
      public void handle(ActionEvent e) {
        text.setX(text.getX() < pane.getWidth() - 100?
          text.getX() + 5 : pane.getWidth() - 100);
      }
    });

    // Tworzenie sceny i umieszczanie jej w oknie
    Scene scene = new Scene(borderPane, 400, 350);
    primaryStage.setTitle("AnonymousHandlerDemo"); // Nagwek
    primaryStage.setScene(scene); // Umieszczanie sceny w oknie
    primaryStage.show(); // Wywietlanie okna
  }

  /**
   * Metoda main jest potrzebna tylko w IDE z ograniczon obsug
   * JavaFX. Nie jest potrzebna do uruchamiania kodu w wierszu polece.
   */
  public static void main(String[] args) {
    launch(args);
  }
}
