import java.util.concurrent.*;

public class AccountWithoutSync {
  private static Account account = new Account();

  public static void main(String[] args) {
    ExecutorService executor = Executors.newCachedThreadPool();

    // Tworzenie i uruchamianie 100 wtkw
    for (int i = 0; i < 100; i++) {
      executor.execute(new AddAPennyTask());
    }

    executor.shutdown();

    // Oczekiwanie na zakoczenie wszystkich zada
    while (!executor.isTerminated()) {
    }

    System.out.println("Stan konta: " + account.getBalance());
  }

  // Wtek dodajcy grosz do konta
  private static class AddAPennyTask implements Runnable {
    public void run() {
      account.deposit(1);
    }
  }

  // Klasa wewntrzna reprezentujca konto
  private static class Account {
    private int balance = 0;

    public int getBalance() {
      return balance;
    }

    public void deposit(int amount) {
      int newBalance = balance + amount;

      // Opnienie jest dodane celowo, aby nasili i
      // uwidoczni problem uszkadzania danych.
      try {
        Thread.sleep(5);
      }
      catch (InterruptedException ex) {
      }

      balance = newBalance;
    }
  }
}
