public class TreePerformanceTest {
  public static void main(String[] args) {
    final int TEST_SIZE = 500000; // Wielkość drzewa używana w testach

    // Tworzenie drzewa AVL
    Tree<Integer> tree1 = new AVLTree<Integer>();
    System.out.println("Czas dla drzewa AVL: " +
      getTime(tree1, TEST_SIZE) + " ms");

    // Tworzenie drzewa 2-3-4
    Tree<Integer> tree2 = new Tree24<Integer>();
    System.out.println("Czas dla drzewa 2­3-4: "
      + getTime(tree2, TEST_SIZE) + " ms");

    // Tworzenie drzewa czerwono-czarnego
    Tree<Integer> tree3 = new RBTree<Integer>();
    System.out.println("Czas dla drzewa czerwono-czarnego: "
      + getTime(tree3, TEST_SIZE) + " ms");
  }

  public static long getTime(Tree<Integer> tree, int testSize) {
    long startTime = System.currentTimeMillis(); // Czas początkowy

    // Tworzenie listy do przechowywania różnych liczb całkowitych
    java.util.List<Integer> list = new java.util.ArrayList<Integer>();
    for (int i = 0; i < testSize; i++)
      list.add(i);

    java.util.Collections.shuffle(list); // Tasowanie listy

    // Wstawianie elementów z listy do drzewa
    for (int i = 0; i < testSize; i++)
      tree.insert(list.get(i));

    java.util.Collections.shuffle(list); // Tasowanie listy

    // Usuwanie elementów z listy z drzewa
    for (int i = 0; i < testSize; i++)
      tree.delete(list.get(i));

    // Zwracanie czasu wykonywania operacji
    return System.currentTimeMillis() - startTime;
  }
}
