import java.util.*;

public class SetListPerformanceTest {
  static final int N = 5000;
  
  public static void main(String[] args) {  
    // Dodawanie liczb 0, 1, 2, …, N – 1 do listy ArrayList
    List<Integer> list = new ArrayList<>();
    for (int i = 0; i < N; i++)
      list.add(i);
    Collections.shuffle(list); // Tasowanie elementów listy ArrayList
    
    // Tworzenie zbioru HashSet i sprawdzanie jego wydajności
    Collection<Integer> set1 = new HashSet<>(list);
    System.out.println("Sprawdzanie przynależności do zbioru HashSet: " +
      getTestTime(set1) + " ms");
    System.out.println("Usuwanie elementu ze zbioru HashSet: " +
      getRemoveTime(set1) + " ms");
    
    // Tworzenie zbioru LinkedHashSet i sprawdzanie jego wydajności
    Collection<Integer> set2 = new LinkedHashSet<>(list);
    System.out.println("Sprawdzanie przynależności do zbioru LinkedHashSet: " +
      getTestTime(set2) + " ms");
    System.out.println("Usuwanie elementu ze zbioru LinkedHashSet: "
      + getRemoveTime(set2) + " ms");

    // Tworzenie zbioru TreeSet i sprawdzanie jego wydajności
    Collection<Integer> set3 = new TreeSet<>(list);
    System.out.println("Sprawdzanie przynależności do zbioru TreeSet: " +
      getTestTime(set3) + " ms");
    System.out.println("Usuwanie elementu ze zbioru TreeSet: " +
      getRemoveTime(set3) + " ms");

    // Tworzenie listy ArrayList i sprawdzanie jej wydajności
    Collection<Integer> list1 = new ArrayList<>(list);
    System.out.println("Sprawdzanie przynależności do listy ArrayList: " +
      getTestTime(list1) + " ms");
    System.out.println("Usuwanie elementu z listy ArrayList: " +
      getRemoveTime(list1) + " ms");

    // Tworzenie listy LinkedList i sprawdzanie jej wydajności
    Collection<Integer> list2 = new LinkedList<>(list);
    System.out.println("Sprawdzanie przynależności do listy LinkedList: " +
      getTestTime(list2) + " ms");
    System.out.println("Usuwanie elementu z listy LinkedList: " +
      getRemoveTime(list2) + " ms");
  }

  public static long getTestTime(Collection<Integer> c) {
    long startTime = System.currentTimeMillis();

    // Sprawdzanie, czy liczba znajduje się w kolekcji
    for (int i = 0; i < N; i++)
      c.contains((int)(Math.random() * 2 * N));

    return System.currentTimeMillis() - startTime; 
  }
  
  public static long getRemoveTime(Collection<Integer> c) {
    long startTime = System.currentTimeMillis();

    for (int i = 0; i < N; i++)
      c.remove(i);

    return System.currentTimeMillis() - startTime; 
  }
}