import java.util.*;

public class CountOccurrenceOfWords {
  public static void main(String[] args) {
    // Ustawianie tekstu w łańcuchu znaków
    String text = "Dzień dobry. Oferujemy dobry towar. " +
      "To dobry interes. Dzień zakupów!";

    // Odwzorowanie TreeMap zawierające słowa jako klucze i liczbę wystąpień jako wartość
    Map<String, Integer> map = new TreeMap<>();

    String[] words = text.split("[\\s+\\p{P}]");
    for (int i = 0; i < words.length; i++) {
      String key = words[i].toLowerCase();
      
      if (key.length() > 0) {
        if (!map.containsKey(key)) {
          map.put(key, 1);
        }
        else {
          int value = map.get(key);
          value++;
          map.put(key, value);
        }
      }
    }

    // Wyświetlanie klucza i wartości dla każdego wpisu
    map.forEach((k, v) -> System.out.println(k + "\t" + v));
  }
}
