import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Scene;
import javafx.scene.control.CheckBox;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import javafx.stage.Stage;

public class CheckBoxDemo extends ButtonDemo {
  @Override // Przesłanienie metody getPane() z nadklasy
  protected BorderPane getPane() {
    BorderPane pane = super.getPane();

    Font fontBoldItalic = Font.font("Times New Roman", 
      FontWeight.BOLD, FontPosture.ITALIC, 20);
    Font fontBold = Font.font("Times New Roman", 
      FontWeight.BOLD, FontPosture.REGULAR, 20);
    Font fontItalic = Font.font("Times New Roman", 
      FontWeight.NORMAL, FontPosture.ITALIC, 20);
    Font fontNormal = Font.font("Times New Roman", 
      FontWeight.NORMAL, FontPosture.REGULAR, 20);
    
    text.setFont(fontNormal);
    
    VBox paneForCheckBoxes = new VBox(20);
    paneForCheckBoxes.setPadding(new Insets(5, 5, 5, 5)); 
    paneForCheckBoxes.setStyle("-fx-border-color: green");
    CheckBox chkBold = new CheckBox("Pogrubienie");
    CheckBox chkItalic = new CheckBox("Kursywa");
    paneForCheckBoxes.getChildren().addAll(chkBold, chkItalic);
    pane.setRight(paneForCheckBoxes);

    EventHandler<ActionEvent> handler = e -> { 
      if (chkBold.isSelected() && chkItalic.isSelected()) {
        text.setFont(fontBoldItalic); // Zaznaczone są oba pola wyboru
      }
      else if (chkBold.isSelected()) {
        text.setFont(fontBold); // Pole wyboru Pogrubienie jest zaznaczone
      }
      else if (chkItalic.isSelected()) {
        text.setFont(fontItalic); // Zaznaczone jest pole wyboru Kursywa
      }      
      else {
        text.setFont(fontNormal); // Żadne pole wyboru nie jest zaznaczone
      }
    };
    
    chkBold.setOnAction(handler);
    chkItalic.setOnAction(handler);
    
    return pane; // Zwracanie nowego panelu
  }
  
  @Override // Przesłanianie metody start z klasy Application
  public void start(Stage primaryStage) {
    super.start(primaryStage);
    primaryStage.setTitle("CheckBoxDemo"); // Nagłówek
  }
  
  /**
  * Metoda main jest potrzebna tylko w IDE z ograniczoną obsługą
  * JavaFX. Nie jest potrzebna przy uruchamianiu kodu w wierszu poleceń.
   */
  public static void main(String[] args) {
    launch(args);
  }
}
