import javafx.application.Application;
import javafx.stage.Stage;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Line;
import javafx.scene.shape.Ellipse;

public class TicTacToe extends Application {
  // Określa, kto powinien wykonać ruch (początkowo X)
  private char whoseTurn = 'X';

  // Tworzenie i inicjowanie komórek
  private Cell[][] cell =  new Cell[3][3];

  // Tworzenie i inicjowanie etykiety ze stanem gry
  private Label lblStatus = new Label("Ruch gracza X");

  @Override // Przesłanianie metody start z klasy Application
  public void start(Stage primaryStage) {
    // Panel do przechowywania komórek
    GridPane pane = new GridPane(); 
    for (int i = 0; i < 3; i++)
      for (int j = 0; j < 3; j++)
        pane.add(cell[i][j] = new Cell(), j, i);

    BorderPane borderPane = new BorderPane();
    borderPane.setCenter(pane);
    borderPane.setBottom(lblStatus);
    
    // Tworzenie sceny i umieszczanie jej w oknie
    Scene scene = new Scene(borderPane, 450, 170);
    primaryStage.setTitle("TicTacToe"); // Ustawianie nagłówka okna
    primaryStage.setScene(scene); // Umieszczanie sceny w oknie
    primaryStage.show(); // Wyświetlanie okna
  }

  /** Sprawdza, czy wszystkie komórki są zajęte */
  public boolean isFull() {
    for (int i = 0; i < 3; i++)
      for (int j = 0; j < 3; j++)
        if (cell[i][j].getToken() == ' ')
          return false;

    return true;
  }

  /** Sprawdza, czy gracz używający danego symbolu wygrał grę */
  public boolean isWon(char token) {
    for (int i = 0; i < 3; i++)
      if (cell[i][0].getToken() == token
          && cell[i][1].getToken() == token
          && cell[i][2].getToken() == token) {
        return true;
      }

    for (int j = 0; j < 3; j++)
      if (cell[0][j].getToken() ==  token
          && cell[1][j].getToken() == token
          && cell[2][j].getToken() == token) {
        return true;
      }

    if (cell[0][0].getToken() == token 
        && cell[1][1].getToken() == token        
        && cell[2][2].getToken() == token) {
      return true;
    }

    if (cell[0][2].getToken() == token
        && cell[1][1].getToken() == token
        && cell[2][0].getToken() == token) {
      return true;
    }

    return false;
  }

  // Klasa wewnętrzna reprezentująca komórki
  public class Cell extends Pane {
    // Symbol w danej komórce
    private char token = ' ';

    public Cell() {
      setStyle("-fx-border-color: black"); 
      this.setPrefSize(800, 800);
      this.setOnMouseClicked(e -> handleMouseClick());
    }

    /** Zwracanie symbolu */
    public char getToken() {
      return token;
    }

    /** Ustawianie nowego symbolu */
    public void setToken(char c) {
      token = c;
      
      if (token == 'X') {
        Line line1 = new Line(10, 10, 
          this.getWidth() - 10, this.getHeight() - 10);
        line1.endXProperty().bind(this.widthProperty().subtract(10));
        line1.endYProperty().bind(this.heightProperty().subtract(10));
        Line line2 = new Line(10, this.getHeight() - 10, 
          this.getWidth() - 10, 10);
        line2.startYProperty().bind(
          this.heightProperty().subtract(10));
        line2.endXProperty().bind(this.widthProperty().subtract(10));
        
        // Dodawanie linii do panelu
        this.getChildren().addAll(line1, line2); 
      }
      else if (token == 'O') {
        Ellipse ellipse = new Ellipse(this.getWidth() / 2, 
          this.getHeight() / 2, this.getWidth() / 2 - 10, 
          this.getHeight() / 2 - 10);
        ellipse.centerXProperty().bind(
          this.widthProperty().divide(2));
        ellipse.centerYProperty().bind(
            this.heightProperty().divide(2));
        ellipse.radiusXProperty().bind(
            this.widthProperty().divide(2).subtract(10));        
        ellipse.radiusYProperty().bind(
            this.heightProperty().divide(2).subtract(10));   
        ellipse.setStroke(Color.BLACK);
        ellipse.setFill(Color.WHITE);
        
        getChildren().add(ellipse); // Dodawanie elipsy do panelu
      }
    }

    /* Obsługa zdarzenia kliknięcia myszą */
    private void handleMouseClick() {
      // Jeśli komórka jest pusta i gra się nie skończyła
      if (token == ' ' && whoseTurn != ' ') {
        setToken(whoseTurn); // Zapisywanie symbolu w komórce

        // Sprawdzanie stanu gry
        if (isWon(whoseTurn)) {
          lblStatus.setText(whoseTurn + " wygrał - koniec gry");
          whoseTurn = ' '; // Koniec gry
        }
        else if (isFull()) {
          lblStatus.setText("Remis - koniec gry");
          whoseTurn = ' '; // Koniec gry
        }
        else {
          // Zmiana gracza wykonującego posunięcie
          whoseTurn = (whoseTurn == 'X') ? 'O' : 'X';
          // Wyświetlanie gracza, który ma wykonać ruch
          lblStatus.setText(whoseTurn + "'s turn");
        }
      }
    }
  }
  
  /**
   * Metoda main jest potrzebna tylko w środowiskach IDE z ograniczoną obsługą platformy JavaFX.
   * Nie jest potrzebna przy uruchamianiu kodu w wierszu poleceń.
   */
  public static void main(String[] args) {
    launch(args);
  }
}
