import java.util.Collection;

public interface MyList<E> extends Collection<E> {
  /** Dodaje do listy nowy element o podanym indeksie */
  public void add(int index, E e);

  /** Zwraca element listy o podanym indeksie */
  public E get(int index);

  /** Zwraca indeks pierwszego pasującego elementu listy.
    * −1 oznacza brak dopasowania. */
  public int indexOf(Object e);

  /** Zwraca indeks ostatniego pasującego elementu listy.
    * −1 oznacza brak dopasowania. */
  public int lastIndexOf(E e);

  /** Usuwa z listy element z podanej pozycji.
    * Dalsze elementy są przesuwane w lewo.
    * Zwraca usunięty element. */
  public E remove(int index);

  /** Zastępuje na liście element o wskazanej pozycji
    * podanym elementem; zwraca zastąpioną wartość. */
  public E set(int index, E e);
  
  @Override /** Dodaje nowy element na końcu listy */
  public default boolean add(E e) {
    add(size(), e);
    return true;
  }

  @Override /** Zwraca true, jeśli lista nie zawiera elementów */
  public default boolean isEmpty() {
    return size() == 0;
  }

  @Override /** Usuwa pierwsze wystąpienie elementu e
   * z listy. Dalsze elementy są przesuwane w lewo.
   * Zwraca true, jeśli element został usunięty. */
  public default boolean remove(Object e) {
    if (indexOf(e) >= 0) {
      remove(indexOf(e));
      return true;
    }
    else
      return false;
  }

  @Override
  public default boolean containsAll(Collection<?> c) {
    // Ćwiczenie dla czytelników
    return true;
  }

  @Override
  public default boolean addAll(Collection<? extends E> c) {
    // Ćwiczenie dla czytelników
    return true;
  }

  @Override
  public default boolean removeAll(Collection<?> c) {
    // Ćwiczenie dla czytelników
    return true;
  }

  @Override
  public default boolean retainAll(Collection<?> c) {
    // Ćwiczenie dla czytelników
    return true;
  }

  @Override
  public default Object[] toArray() {
    // Ćwiczenie dla czytelników
    return null;
  }

  @Override
  public default <T> T[] toArray(T[] array) {
    // Ćwiczenie dla czytelników
    return null;
  }
}