import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.stage.Stage;

public class MultipleStageDemo extends Application {
  @Override // Przesłanianie metody start z klasy Application
  public void start(Stage primaryStage) {
    // Tworzenie sceny i umieszczanie na niej przycisku
    Scene scene = new Scene(new Button("OK"), 200, 250);
    primaryStage.setTitle("MyJavaFX"); // Ustawianie nagłówka okna
    primaryStage.setScene(scene); // Umieszczanie sceny w oknie
    primaryStage.show(); // Wyświetlanie okna

    Stage stage = new Stage(); // Tworzenie nowego okna
    stage.setTitle("Drugie okno"); // Ustawianie nagłówka okna
    // Umieszczanie sceny z przyciskiem w oknie
    stage.setScene(new Scene(new Button("Nowe okno"), 200, 250));        
    stage.show(); // Wyświetlanie okna
  }
  
  /**
   * Metoda main jest potrzebna tylko w środowiskach IDE z ograniczoną obsługą platformy JavaFX.
   * Nie jest potrzebna przy uruchamianiu kodu w wierszu poleceń.
   */
  public static void main(String[] args) {
    launch(args);
  }
}
