import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.text.Text;
import javafx.stage.Stage;

public class LambdaHandlerDemo extends Application {
  @Override // Przesłanianie metody start z klasy Application
  public void start(Stage primaryStage) {
    Text text = new Text(40, 40, "Programowanie to przyjemność");
    Pane pane = new Pane(text);
    
    // Panel HBox zawiera cztery przyciski
    Button btUp = new Button("W górę");
    Button btDown = new Button("W dół");
    Button btLeft = new Button("W lewo");
    Button btRight = new Button("W prawo");
    HBox hBox = new HBox(btUp, btDown, btLeft, btRight);
    hBox.setSpacing(10);
    hBox.setAlignment(Pos.CENTER);
    
    BorderPane borderPane = new BorderPane(pane);
    borderPane.setBottom(hBox);
    
    // Tworzenie i rejestrowanie obiektu obsługi zdarzeń
    btUp.setOnAction((ActionEvent e) -> {
        text.setY(text.getY() > 10 ? text.getY() - 5 : 10);
    });

    btDown.setOnAction((e) -> {
      text.setY(text.getY() < pane.getHeight() ? 
        text.getY() + 5 : pane.getHeight());
    });
    
    btLeft.setOnAction(e -> {
      text.setX(text.getX() > 0 ? text.getX() - 5 : 0);
    });
    
    btRight.setOnAction(e ->
      text.setX(text.getX() < pane.getWidth() - 100?
        text.getX() + 5 : pane.getWidth() - 100)
    );

    // Tworzenie sceny i umieszczanie jej w oknie
    Scene scene = new Scene(borderPane, 400, 350);
    primaryStage.setTitle("AnonymousHandlerDemo"); // Ustawianie nagłówka
    primaryStage.setScene(scene); // Umieszczanie sceny w oknie
    primaryStage.show(); // Wyświetlanie okna
  }
  
  /**
   * Metoda main jest potrzebna tylko w środowiskach IDE z ograniczoną obsługą platformy JavaFX.
   * Nie jest potrzebna przy uruchamianiu kodu w wierszu poleceń.
   */
  public static void main(String[] args) {
    launch(args);
  }
}
