import java.util.Stack;

public class EvaluateExpression {
  public static void main(String[] args) {
    // Sprawdzanie liczby przekazanych argumentów
    if (args.length != 1) {
      System.out.println(
        "Użytkowanie: java EvaluateExpression \"wyrażenie\"");
      System.exit(1);
    }

    try {
      System.out.println(evaluateExpression(args[0]));
    }
    catch (Exception ex) {
      System.out.println("Błędne wyrażenie: " + args[0]);
    }
  }

  /** Przetwarzanie wyrażenia */ 
  public static int evaluateExpression(String expression) {
    // Tworzenie stosu operandStack do przechowywania operandów
    Stack<Integer> operandStack = new Stack<>();
  
    // Tworzenie stosu operatorStack do przechowywania operatorów
    Stack<Character> operatorStack = new Stack<>();
  
    // Wstawianie odstępów wokół symboli (, ), +, –, / i *
    expression = insertBlanks(expression);

    // Pobieranie operandów i operatorów
    String[] tokens = expression.split(" ");

    // Etap 1. Analiza tokenów
    for (String token: tokens) {
      if (token.length() == 0) // Spacja
        continue; // Powrót do pętli while w celu pobrania następnego tokena
      else if (token.charAt(0) == '+' || token.charAt(0) == '-') {
        // Przetwarzanie operatorów +, –, *, / z wierzchołka stosu z operatorami
        while (!operatorStack.isEmpty() &&
          (operatorStack.peek() == '+' || 
           operatorStack.peek() == '-' ||
           operatorStack.peek() == '*' ||
           operatorStack.peek() == '/')) {
          processAnOperator(operandStack, operatorStack);
        }

        // Dodawanie operatora + lub – na stos operatorów
        operatorStack.push(token.charAt(0));
      }
      else if (token.charAt(0) == '*' || token.charAt(0) == '/') {
        // Przetwarzanie wszystkich operatorów *, / z wierzchołka stosu operatorów
        while (!operatorStack.isEmpty() &&
          (operatorStack.peek() == '*' ||
          operatorStack.peek() == '/')) {
          processAnOperator(operandStack, operatorStack);
        }

        // Umieszczanie operatora * lub / na stosie operatorów
        operatorStack.push(token.charAt(0));
      }
      else if (token.trim().charAt(0) == '(') {
        operatorStack.push('('); // Umieszczanie '(' na stosie
      }
      else if (token.trim().charAt(0) == ')') {
        // Przetwarzanie wszystkich operatorów ze stosu do czasu napotkania '('
        while (operatorStack.peek() != '(') {
          processAnOperator(operandStack, operatorStack);
        }
        
        operatorStack.pop(); // Zdejmowanie symbolu '(' ze stosu
      }
      else { // Znaleziono operand
             // Umieszczanie operandu na stosie
        operandStack.push(Integer.valueOf(token));
      }
    }

    // Etap 2. Przetwarzanie wszystkich pozostałych operatorów ze stosu
    while (!operatorStack.isEmpty()) {
      processAnOperator(operandStack, operatorStack);
    }

    // Zwracanie wyniku
    return operandStack.pop();
  }

  /** Przetwarzanie jednego operatora: pobieranie go ze stosu operatorStack i
    * stosowanie do operandów ze stosu operandStack */
  public static void processAnOperator(
      Stack<Integer> operandStack, Stack<Character> operatorStack) {
    char op = operatorStack.pop();
    int op1 = operandStack.pop();
    int op2 = operandStack.pop();
    if (op == '+') 
      operandStack.push(op2 + op1);
    else if (op == '-') 
      operandStack.push(op2 - op1);
    else if (op == '*') 
      operandStack.push(op2 * op1);
    else if (op == '/') 
      operandStack.push(op2 / op1);
  }
  
  public static String insertBlanks(String s) {
    String result = "";
    
    for (int i = 0; i < s.length(); i++) {
      if (s.charAt(i) == '(' || s.charAt(i) == ')' || 
          s.charAt(i) == '+' || s.charAt(i) == '-' ||
          s.charAt(i) == '*' || s.charAt(i) == '/')
        result += " " + s.charAt(i) + " ";
      else
        result += s.charAt(i);
    }
    
    return result;
  }
}
