import java.util.Locale;
import javafx.application.Application;
import javafx.geometry.Pos;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;

public class CalendarApp extends Application {
  private CalendarPane calendarPane = new CalendarPane();
  private Button btPrior = new Button("Poprzedni");
  private Button btNext = new Button("Następny");
  private ComboBox<String> cboLocales = new ComboBox<>();
  private Locale[] availableLocales = Locale.getAvailableLocales();
  
  @Override // Przesłanianie metody start z klasy Application
  public void start(Stage primaryStage) {
    HBox hBox = new HBox(5);
    hBox.getChildren().addAll(btPrior, btNext);
    hBox.setAlignment(Pos.CENTER);

	// Inicjowanie pola cboLocales wszystkimi dostępnymi ustawieniami regionalnymi
    setAvailableLocales();
    HBox hBoxLocale = new HBox(5);
    hBoxLocale.getChildren().addAll(
      new Label("Ustawienia regionalne"), cboLocales);

    BorderPane pane = new BorderPane();
    pane.setCenter(calendarPane);
    pane.setTop(hBoxLocale);
    hBoxLocale.setAlignment(Pos.CENTER);
    pane.setBottom(hBox);
    hBox.setAlignment(Pos.CENTER);
    
    // Tworzenie sceny i umieszczanie jej w oknie
    Scene scene = new Scene(pane, 600, 300);
    primaryStage.setTitle("CalendarApp"); // Ustawianie nagłówka okna
    primaryStage.setScene(scene); // Umieszczanie sceny w oknie
    primaryStage.show(); // Wyświetlanie okna

    btPrior.setOnAction(e -> {
      int currentMonth = calendarPane.getMonth();
      if (currentMonth == 0) { // Poprzedni miesiąc to grudzień (11)
        calendarPane.setYear(calendarPane.getYear() - 1);
        calendarPane.setMonth(11);
      }
      else {
        calendarPane.setMonth((currentMonth - 1) % 12);
      }
    });
    
    btNext.setOnAction(e -> {
      int currentMonth = calendarPane.getMonth();
      if (currentMonth == 11) // Następny miesiąc to styczeń (0)
        calendarPane.setYear(calendarPane.getYear() + 1);

      calendarPane.setMonth((currentMonth + 1) % 12);
    });
    
    cboLocales.setOnAction(e ->
      calendarPane.setLocale(availableLocales[cboLocales.
        getSelectionModel().getSelectedIndex()]));
  }

  private void setAvailableLocales() {
    for (int i = 0; i < availableLocales.length; i++) 
      cboLocales.getItems().add(availableLocales[i]
       .getDisplayName() + " " + availableLocales[i].toString());

    cboLocales.getSelectionModel().selectFirst();
  }
    
  /**
  * Metoda main jest potrzebna tylko w IDE z ograniczoną obsługą
  * JavaFX. Nie jest potrzebna przy uruchamianiu kodu w wierszu poleceń.
   */
  public static void main(String[] args) {
    launch(args);
  }
}