import java.util.concurrent.*;
import java.util.concurrent.locks.*;

public class AccountWithSyncUsingLock {
  private static Account account = new Account();

  public static void main(String[] args) {
    ExecutorService executor = Executors.newCachedThreadPool();

    // Tworzenie i uruchamianie 100 wtkw
    for (int i = 0; i < 100; i++) {
      executor.execute(new AddAPennyTask());
    }

    executor.shutdown();

    // Oczekiwanie na ukoczenie wszystkich zada
    while (!executor.isTerminated()) {
    }

    System.out.println("Stan konta: " + account.getBalance());
  }

  // Wtek dodajcy grosz do konta
  public static class AddAPennyTask implements Runnable {
    public void run() {
      account.deposit(1);
    }
  }

  // Klasa wewntrzna Account
  public static class Account {
    private static Lock lock = new ReentrantLock(); // Tworzenie blokady
    private int balance = 0;

    public int getBalance() {
      return balance;
    }

    public void deposit(int amount) {
      lock.lock(); // Zajmowanie blokady

      try {
        int newBalance = balance + amount;

        // Opnienie jest dodane celowo, aby nasili i uwidoczni
        // problemy z uszkadzaniem danych
        Thread.sleep(5);

        balance = newBalance;
      }
      catch (InterruptedException ex) {
      }
      finally {
        lock.unlock(); // Zwalnianie blokady
      }
    }
  }
}
