public class TotalArea {
  /** Metoda main */
  public static void main(String[] args) {
    // Deklaracja zmiennej circleArray
    CircleWithPrivateDataFields[] circleArray;

    // Tworzenie tablicy circleArray
    circleArray = createCircleArray();

    // Wyświetlanie tablicy circleArray i łącznej powierzchni kół
    printCircleArray(circleArray);
  }

  /** Tworzy tablicę obiektów typu Circle */
  public static CircleWithPrivateDataFields[] createCircleArray() {
    CircleWithPrivateDataFields[] circleArray =
      new CircleWithPrivateDataFields[5];

    for (int i = 0; i < circleArray.length; i++) {
      circleArray[i] =
        new CircleWithPrivateDataFields(Math.random() * 100);
    }

    // Zwracanie tablicy obiektów typu Circle
    return circleArray;
  }

  /** Wyświetlanie tablicy kół i ich łącznej powierzchni */
  public static void printCircleArray(
      CircleWithPrivateDataFields[] circleArray) {
    System.out.printf("%-30s%-15s\n", "Promień", "Powierzchnia");
    for (int i = 0; i < circleArray.length; i++) {
      System.out.printf("%-30f%-15f\n", circleArray[i].getRadius(),
        circleArray[i].getArea());
    }

    System.out.println("-----------------------------------------");

    // Obliczanie i wyświetlanie wyniku
    System.out.printf("%-30s%-15f\n", "Łączna powierzchnia kół wynosi",
      sum(circleArray));
  }

  /** Dodaje powierzchnie kół */
  public static double sum(
      CircleWithPrivateDataFields[] circleArray) {
    // Inicjowanie zmiennej sum
    double sum = 0;

    // Dodawanie powierzchni do zmiennej sum
    for (int i = 0; i < circleArray.length; i++)
      sum += circleArray[i].getArea();

    return sum;
  }
}
