import java.io.*;
import java.net.*;
import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;

public class StudentClient extends Application {
  private TextField tfName = new TextField();
  private TextField tfStreet = new TextField();
  private TextField tfCity = new TextField();
  private TextField tfState = new TextField();
  private TextField tfZip = new TextField();

  // Przycisk do przesyłania danych studenta na serwer
  private Button btRegister = new Button("Zarejestruj na serwerze");

  // Nazwa lub adres IP hosta
  String host = "localhost";

  @Override // Przesłanianie metody start z klasy Application
  public void start(Stage primaryStage) {
    GridPane pane = new GridPane();
    pane.add(new Label("Nazwisko"), 0, 0);
    pane.add(tfName, 1, 0);    
    pane.add(new Label("Ulica"), 0, 1);
    pane.add(tfStreet, 1, 1);
    pane.add(new Label("Miasto"), 0, 2);
    
    HBox hBox = new HBox(2);
    pane.add(hBox, 1, 2);
    hBox.getChildren().addAll(tfCity, new Label("Województwo"), tfState,
      new Label("Kod"), tfZip);
    pane.add(btRegister, 1, 3);
    GridPane.setHalignment(btRegister, HPos.RIGHT);
    
    pane.setAlignment(Pos.CENTER);   
    tfName.setPrefColumnCount(15);
    tfStreet.setPrefColumnCount(15);
    tfCity.setPrefColumnCount(10);
    tfState.setPrefColumnCount(2);
    tfZip.setPrefColumnCount(3);

    btRegister.setOnAction(new ButtonListener());
    
    // Tworzenie sceny i umieszczanie jej w oknie
    Scene scene = new Scene(pane, 450, 200);
    primaryStage.setTitle("StudentClient"); // Ustawianie nagłówka okna
    primaryStage.setScene(scene); // Umieszczanie sceny w oknie
    primaryStage.show(); // Wyświetlanie okna
  }

  /** Obsługa zdarzeń */
  private class ButtonListener implements EventHandler<ActionEvent> {
    @Override
    public void handle(ActionEvent e) {
      try {
        // Nawiązywanie połączenia z serwerem
        Socket socket = new Socket(host, 8000);

        // Tworzenie strumienia wyjściowego z danymi dla serwera
        ObjectOutputStream toServer =
          new ObjectOutputStream(socket.getOutputStream());

        // Pobieranie zawartości pól tekstowych
        String name = tfName.getText().trim();
        String street = tfStreet.getText().trim();
        String city = tfCity.getText().trim();
        String state = tfState.getText().trim();
        String zip = tfZip.getText().trim();

        // Tworzenie obiektu typu StudentAddress i przesyłanie go na serwer
        StudentAddress s =
          new StudentAddress(name, street, city, state, zip);
        toServer.writeObject(s);
      }
      catch (IOException ex) {
        ex.printStackTrace();
      }
    }
  }
  
  /**
   * Metoda main jest potrzebna tylko w środowiskach IDE z ograniczoną obsługą platformy JavaFX.
   * Nie jest potrzebna przy uruchamianiu kodu w wierszu poleceń.
   */
  public static void main(String[] args) {
    launch(args);
  }
}
