import javafx.application.Application;
import javafx.geometry.Orientation;
import javafx.scene.Scene;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TextArea;
import javafx.scene.control.ToggleGroup;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class SplitPaneDemo extends Application {
  private Image usImage = new Image(
    "https://liveexample.pearsoncmg.com/common/image/us.gif");
  private Image ukImage = new Image(
    "https://liveexample.pearsoncmg.com/common/image/uk.gif");
  private Image caImage = new Image(
    "https://liveexample.pearsoncmg.com/common/image/ca.gif");
  private String usDescription = "Opis USA...";
  private String ukDescription = "Opis Wielkiej Brytanii...";
  private String caDescription = "Opis Kanady...";

  @Override // Przesłanianie metody start z klasy Application
  public void start(Stage primaryStage) {   
    VBox vBox = new VBox(10);
    RadioButton rbUS = new RadioButton("USA"); 
    RadioButton rbUK = new RadioButton("Wielka Brytania"); 
    RadioButton rbCA = new RadioButton("Kanada");            
    vBox.getChildren().addAll(rbUS, rbUK, rbCA);
    
    SplitPane content = new SplitPane();
    content.setOrientation(Orientation.VERTICAL);
    ImageView imageView = new ImageView(usImage);
    StackPane imagePane = new StackPane();
    imagePane.getChildren().add(imageView);
    TextArea taDescription = new TextArea();   
    taDescription.setText(usDescription);
    content.getItems().addAll(
      imagePane, new ScrollPane(taDescription));
        
    SplitPane sp = new SplitPane();
    sp.getItems().addAll(vBox, content);

    Scene scene = new Scene(sp, 300, 250);           
    primaryStage.setTitle("SplitPaneDemo"); // Ustawianie nagłówka okna
    primaryStage.setScene(scene); // Umieszczanie sceny w oknie
    primaryStage.show(); // Wyświetlanie okna
    
    // Grupowanie przycisków radio
    ToggleGroup group = new ToggleGroup();
    rbUS.setToggleGroup(group);
    rbUK.setToggleGroup(group);
    rbCA.setToggleGroup(group);

    rbUS.setSelected(true);
    rbUS.setOnAction(e -> {
      imageView.setImage(usImage);
      taDescription.setText(usDescription);
    });
    
    rbUK.setOnAction(e -> {
      imageView.setImage(ukImage);
      taDescription.setText(ukDescription);
    });
        
    rbCA.setOnAction(e -> {
      imageView.setImage(caImage);
      taDescription.setText(caDescription);
    });
  }

  // Program jest uruchamiany w wierszu poleceń
  public static void main(String[] args) {
    launch(args);
  }
}


