public class CountLettersInArray {
  /** Metoda main */
  public static void main(String[] args) {
    // Deklarowanie i tworzenie tablicy
    char[] chars = createArray();

    // Wyświetlanie tablicy
    System.out.println("Małe litery w tablicy:");
    displayArray(chars);

    // Zliczanie wystąpień każdej litery
    int[] counts = countLetters(chars);

    // Wyświetlanie liczby wystąpień
    System.out.println();
    System.out.println("Liczba wystąpień każdej litery:");
    displayCounts(counts);
  }

  /** Tworzenie tablicy znaków */
  public static char[] createArray() {
    // Deklarowanie i tworzenie tablicy znaków
    char[] chars = new char[100];

    // Tworzenie losowych małych liter i przypisywanie ich
    // do tablicy
    for (int i = 0; i < chars.length; i++)
      chars[i] = RandomCharacter.getRandomLowerCaseLetter();

    // Zwracanie tablicy
    return chars;
  }

  /** Wyświetla tablicę znaków */
  public static void displayArray(char[] chars) {
    // Wyświetlanie znaków z tablicy po 20 w wierszu
    for (int i = 0; i < chars.length; i++) {
      if ((i + 1) % 20 == 0)
        System.out.println(chars[i]);
      else
        System.out.print(chars[i] + " ");
    }
  }

  /** Zlicza wystąpienia każdej litery */
  public static int[] countLetters(char[] chars) {
    // Deklarowanie i tworzenie tablicy 26 wartości typu int
    int[] counts = new int[26];

    // Zliczanie wystąpień każdej litery w tablicy
    for (int i = 0; i < chars.length; i++)
      counts[chars[i] - 'a']++;

    return counts;
  }

  /** Wyświetla liczbę wystąpień */
  public static void displayCounts(int[] counts) {
    for (int i = 0; i < counts.length; i++) {
      if ((i + 1) % 10 == 0)
        System.out.println(counts[i] + " " + (char)(i + 'a'));
      else
        System.out.print(counts[i] + " " + (char)(i + 'a') + " ");
    }
  }
}
