import java.util.stream.IntStream;
import java.util.stream.Stream;

public class StreamReductionDemo {
  public static void main(String[] args) {
    int[] values = {3, 4, 1, 5, 20, 1, 3, 3, 4, 6};

    System.out.print("Wartości: ");
      IntStream.of(values).forEach(e -> System.out.print(e + " "));
    
    System.out.println("\nWynik pomnożenia wszystkich wartości: " +
      IntStream.of(values).parallel().reduce(1, (e1, e2) -> e1 * e2));

    System.out.print("Wartości: " +
      IntStream.of(values).mapToObj(e -> e + "")
        .reduce((e1, e2) -> e1 + ", " + e2).get());
        
    String[] names = {"Jan", "Piotr", "Sara", "Kasia", "Julia", 
      "Grzegorz", "Alan", "Sylwia", "Monika", "jan"};
    System.out.print("\nImiona: ");
    System.out.println(Stream.of(names)
      .reduce((x, y) -> x + ", " + y).get());
       
    System.out.print("Złączanie imion: ");
    System.out.println(Stream.of(names)
      .reduce((x, y) -> x + y).get());
    
    System.out.print("Liczba znaków w sumie: ");
    System.out.println(Stream.of(names)
      .reduce((x, y) -> x + y).get().length());
  }
}
