public interface MyMap<K, V> {
  /** Usuwa wszystkie wpisy z odwzorowania */
  public void clear();
  
  /** Zwraca true, jeśli podany klucz występuje w odwzorowaniu */
  public boolean containsKey(K key);
  
  /** Zwraca true, jeśli odwzorowanie zawiera podaną wartość */ 
  public boolean containsValue(V value);

  /** Zwraca zbiór wpisów z odwzorowania */
  public java.util.Set<Entry<K, V>> entrySet();

  /** Zwraca wartość powiązaną z podanym kluczem */
  public V get(K key);
  
  /** Zwraca true, jeśli odwzorowanie jest puste */
  public boolean isEmpty();

  /** Zwraca zbiór zawierający klucze z odwzorowania */
  public java.util.Set<K> keySet();
  
  /** Dodaje do odwzorowania wpis (klucz, wartość) */
  public V put(K key, V value);

  /** Usuwa wpis z podanym kluczem */
  public void remove(K key);

  /** Zwraca liczbę wpisów w odwzorowaniu */
  public int size();

  /** Zwraca zbiór zawierający wartości z odwzorowania */
  public java.util.Set<V> values();
  
  /** Definicja klasy wewnętrznej Entry */
  public static class Entry<K, V> {
    K key;
    V value;
    
    public Entry(K key, V value) {
      this.key = key;
      this.value = value;
    }
    
    public K getKey() {
      return key;
    }
    
    public V getValue() {
      return value;
    }
    
    @Override
    public String toString() {
      return "[" + key + ", " + value + "]";
    }
  }
}    
