import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CountOccurrenceOfWordsStream {
  public static void main(String[] args) {
    // Tekst w łańcuchu znaków
    String text = "I jeszcze jeden, i jeszcze raz, "
      + "sto lat, sto lat niech żyją nam!";

    Stream.of(text.split("[\\s+\\p{Punct}]")).parallel()
      .filter(e -> e.length() > 0).collect(
        Collectors.groupingBy(String::toLowerCase, TreeMap::new,
          Collectors.counting()))
      .forEach((k, v) -> System.out.println(k + " " + v));
  }
}