import javafx.application.Application;
import javafx.stage.Stage;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Scene;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;

public class ComboBoxDemo extends Application {
  // Deklarowanie tablicy łańcuchów znaków z podpisami flag
  private String[] flagTitles = {"Kanada", "Chiny", "Dania", 
    "Francja", "Niemcy", "Indie", "Norwegia", "Wielka Brytania",
    "USA"};

  // Deklarowanie tablicy ImageView z flagami 9 państw
  private ImageView[] flagImage = {new ImageView("image/ca.gif"),
    new ImageView("image/china.gif"), 
    new ImageView("image/denmark.gif"), 
    new ImageView("image/fr.gif"), 
    new ImageView("image/germany.gif"),
    new ImageView("image/india.gif"), 
    new ImageView("image/norway.gif"),
    new ImageView("image/uk.gif"), new ImageView("image/us.gif")};

  // Deklarowanie tablicy z opisami flag
  private String[] flagDescription = new String[9];

  // Deklarowanie i tworzenie panelu DescriptionPane
  private DescriptionPane descriptionPane = new DescriptionPane();

  // Tworzenie pola kombi do wybierania państw
  private ComboBox<String> cbo = new ComboBox<>(); // Nazwy państw

  @Override // Przesłanianie metody start z klasy Application
  public void start(Stage primaryStage) {
    // Ustawianie opisów
    flagDescription[0] = "Flaga kanadyjska... ";
    flagDescription[1] = "Opis flagi chińskiej... ";
    flagDescription[2] = "Opis flagi duńskiej... ";
    flagDescription[3] = "Opis flagi francuskiej... ";
    flagDescription[4] = "Opis flagi niemieckiej... ";
    flagDescription[5] = "Opis flagi indyjskiej... ";
    flagDescription[6] = "Opis flagi norweskiej... ";
    flagDescription[7] = "Opis flagi brytyjskiej... ";
    flagDescription[8] = "Opis flagi amerykańskiej... ";

    // Wyświetlany ma być pierwszy kraj (Kanada)
    setDisplay(0);

    // Dodawanie pola kombi i panelu DescriptionPane do panelu BorderPane
    BorderPane pane = new BorderPane();
      
    BorderPane paneForComboBox = new BorderPane();
    paneForComboBox.setLeft(new Label("Wybierz kraj: "));
    paneForComboBox.setCenter(cbo);
    pane.setTop(paneForComboBox);
    cbo.setPrefWidth(400);
    cbo.setValue("Kanada");
    
    ObservableList<String> items = 
      FXCollections.observableArrayList(flagTitles);
    cbo.getItems().addAll(items); 
    pane.setCenter(descriptionPane);
    
    // Wyświetlanie wybranego kraju
    cbo.setOnAction(e -> setDisplay(items.indexOf(cbo.getValue())));
    
    // Tworzenie sceny i umieszczanie jej w oknie
    Scene scene = new Scene(pane, 450, 170);
    primaryStage.setTitle("ComboBoxDemo"); // Ustawianie nagłówka okna
    primaryStage.setScene(scene); // Umieszczanie sceny w oknie
    primaryStage.show(); // Wyświetlanie okna
  }

  /** Ustawianie informacji wyświetlanych w panelu DescriptionPane */
  public void setDisplay(int index) {
    descriptionPane.setTitle(flagTitles[index]);
    descriptionPane.setImageView(flagImage[index]);
    descriptionPane.setDescription(flagDescription[index]);
  }

  /**
   * Metoda main jest potrzebna tylko w środowiskach IDE z ograniczoną obsługą platformy JavaFX.
   * Nie jest potrzebna przy uruchamianiu kodu w wierszu poleceń.
   */
  public static void main(String[] args) {
    launch(args);
  }
}
