import java.util.Scanner;

public class CheckSudokuSolution {
  public static void main(String[] args) {
    // Wczytywanie rozwiązania 
    int[][] grid = readASolution();

    System.out.println(isValid(grid) ? "Poprawne rozwiązanie" 
      : "Błędne rozwiązanie");
  }

  /** Wczytywanie rozwiązania sudoku z konsoli */
  public static int[][] readASolution() {
    // Tworzenie obiektu typu Scanner
    Scanner input = new Scanner(System.in);

    System.out.println("Podaj rozwiązanie łamigłówki sudoku:");
    int[][] grid = new int[9][9];
    for (int i = 0; i < 9; i++)
      for (int j = 0; j < 9; j++)
        grid[i][j] = input.nextInt();

    return grid;
  }

  /** Sprawdza, czy rozwiązanie jest poprawne */
  public static boolean isValid(int[][] grid) {
    for (int i = 0; i < 9; i++)
      for (int j = 0; j < 9; j++)
        if (grid[i][j] < 1 || grid[i][j] > 9 
            || !isValid(i, j, grid))
          return false;
    return true; // Rozwiązanie jest poprawne
  }

  /** Sprawdzanie, czy wartość grid[i][j] w siatce jest poprawna */
  public static boolean isValid(int i, int j, int[][] grid) {
    // Sprawdzanie, czy wartość grid[i][j] jest unikatowa w wierszu i
    for (int column = 0; column < 9; column++)
      if (column != j && grid[i][column] == grid[i][j])
        return false;

    // Sprawdzanie, czy wartość grid[i][j] jest unikatowa w kolumnie j
    for (int row = 0; row < 9; row++)
      if (row != i && grid[row][j] == grid[i][j])
        return false;

    // Sprawdzanie, czy wartość grid[i][j] jest unikatowa w bloku 3×3
    for (int row = (i / 3) * 3; row < (i / 3) * 3 + 3; row++)
      for (int col = (j / 3) * 3; col < (j / 3) * 3 + 3; col++)
        if (!(row == i && col == j) && grid[row][col] == grid[i][j])
          return false;

    return true; // Wartość grid[i][j] jest poprawna
  }
}